# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' AWS Cost Explorer Service
#'
#' @description
#' The Cost Explorer API enables you to programmatically query your cost
#' and usage data. You can query for aggregated data such as total monthly
#' costs or total daily usage. You can also query for granular data, such
#' as the number of daily write operations for Amazon DynamoDB database
#' tables in your production environment.
#' 
#' Service Endpoint
#' 
#' The Cost Explorer API provides the following endpoint:
#' 
#' -   `https://ce.us-east-1.amazonaws.com`
#' 
#' For information about costs associated with the Cost Explorer API, see
#' [AWS Cost Management
#' Pricing](https://aws.amazon.com/aws-cost-management/pricing/).
#'
#' @examples
#' \donttest{svc <- costexplorer()
#' svc$get_cost_and_usage(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=costexplorer_get_cost_and_usage]{get_cost_and_usage} \tab Retrieves cost and usage metrics for your account \cr
#'  \link[=costexplorer_get_cost_forecast]{get_cost_forecast} \tab Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period that you select, based on your past costs\cr
#'  \link[=costexplorer_get_dimension_values]{get_dimension_values} \tab Retrieves all available filter values for a specified filter over a period of time \cr
#'  \link[=costexplorer_get_reservation_coverage]{get_reservation_coverage} \tab Retrieves the reservation coverage for your account \cr
#'  \link[=costexplorer_get_reservation_purchase_recommendation]{get_reservation_purchase_recommendation} \tab Gets recommendations for which reservations to purchase \cr
#'  \link[=costexplorer_get_reservation_utilization]{get_reservation_utilization} \tab Retrieves the reservation utilization for your account \cr
#'  \link[=costexplorer_get_tags]{get_tags} \tab Queries for available tag keys and tag values for a specified period 
#' }
#'
#' @rdname costexplorer
#' @export
costexplorer <- function() {
  .costexplorer$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.costexplorer <- list()

.costexplorer$operations <- list()

.costexplorer$metadata <- list(
  service_name = "ce",
  endpoints = list("*" = "ce.{region}.amazonaws.com", "cn-*" = "ce.{region}.amazonaws.com.cn"),
  service_id = "Cost Explorer",
  api_version = "2017-10-25",
  signing_name = "ce",
  json_version = "1.1",
  target_prefix = "AWSInsightsIndexService"
)

.costexplorer$handlers <- new_handlers("jsonrpc", "v4")

.costexplorer$service <- function() {
  new_service(.costexplorer$metadata, .costexplorer$handlers)
}
