% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_dimension_values}
\alias{costexplorer_get_dimension_values}
\title{Retrieves all available filter values for a specified filter over a
period of time}
\usage{
costexplorer_get_dimension_values(SearchString, TimePeriod, Dimension,
  Context, NextPageToken)
}
\arguments{
\item{SearchString}{The value that you want to search the filter values for.}

\item{TimePeriod}{[required] The start and end dates for retrieving the dimension values. The start
date is inclusive, but the end date is exclusive. For example, if
\code{start} is \code{2017-01-01} and \code{end} is \code{2017-05-01}, then the cost and
usage data is retrieved from \code{2017-01-01} up to and including
\code{2017-04-30} but not including \code{2017-05-01}.}

\item{Dimension}{[required] The name of the dimension. Each \code{Dimension} is available for a different
\code{Context}. For more information, see \code{Context}.}

\item{Context}{The context for the call to \code{GetDimensionValues}. This can be
\code{RESERVATIONS} or \code{COST_AND_USAGE}. The default value is
\code{COST_AND_USAGE}. If the context is set to \code{RESERVATIONS}, the resulting
dimension values can be used in the \code{GetReservationUtilization}
operation. If the context is set to \code{COST_AND_USAGE}, the resulting
dimension values can be used in the \code{GetCostAndUsage} operation.

If you set the context to \code{COST_AND_USAGE}, you can use the following
dimensions for searching:
\itemize{
\item AZ - The Availability Zone. An example is \code{us-east-1a}.
\item DATABASE\_ENGINE - The Amazon Relational Database Service database.
Examples are Aurora or MySQL.
\item INSTANCE\_TYPE - The type of Amazon EC2 instance. An example is
\code{m4.xlarge}.
\item LEGAL\_ENTITY\_NAME - The name of the organization that sells you
AWS services, such as Amazon Web Services.
\item LINKED\_ACCOUNT - The description in the attribute map that includes
the full name of the member account. The value field contains the
AWS ID of the member account.
\item OPERATING\_SYSTEM - The operating system. Examples are Windows or
Linux.
\item OPERATION - The action performed. Examples include \code{RunInstance} and
\code{CreateBucket}.
\item PLATFORM - The Amazon EC2 operating system. Examples are Windows or
Linux.
\item PURCHASE\_TYPE - The reservation type of the purchase to which this
usage is related. Examples include On-Demand Instances and Standard
Reserved Instances.
\item SERVICE - The AWS service such as Amazon DynamoDB.
\item USAGE\_TYPE - The type of usage. An example is
DataTransfer-In-Bytes. The response for the \code{GetDimensionValues}
operation includes a unit attribute. Examples include GB and Hrs.
\item USAGE\_TYPE\_GROUP - The grouping of common usage types. An example
is Amazon EC2: CloudWatch -- Alarms. The response for this operation
includes a unit attribute.
\item RECORD\_TYPE - The different types of charges such as RI fees, usage
costs, tax refunds, and credits.
}

If you set the context to \code{RESERVATIONS}, you can use the following
dimensions for searching:
\itemize{
\item AZ - The Availability Zone. An example is \code{us-east-1a}.
\item CACHE\_ENGINE - The Amazon ElastiCache operating system. Examples
are Windows or Linux.
\item DEPLOYMENT\_OPTION - The scope of Amazon Relational Database Service
deployments. Valid values are \code{SingleAZ} and \code{MultiAZ}.
\item INSTANCE\_TYPE - The type of Amazon EC2 instance. An example is
\code{m4.xlarge}.
\item LINKED\_ACCOUNT - The description in the attribute map that includes
the full name of the member account. The value field contains the
AWS ID of the member account.
\item PLATFORM - The Amazon EC2 operating system. Examples are Windows or
Linux.
\item REGION - The AWS Region.
\item SCOPE (Utilization only) - The scope of a Reserved Instance (RI).
Values are regional or a single Availability Zone.
\item TAG (Coverage only) - The tags that are associated with a Reserved
Instance (RI).
\item TENANCY - The tenancy of a resource. Examples are shared or
dedicated.
}}

\item{NextPageToken}{The token to retrieve the next set of results. AWS provides the token
when the response from a previous call has more results than the maximum
page size.}
}
\description{
Retrieves all available filter values for a specified filter over a
period of time. You can search the dimension values for an arbitrary
string.
}
\section{Request syntax}{
\preformatted{svc$get_dimension_values(
  SearchString = "string",
  TimePeriod = list(
    Start = "string",
    End = "string"
  ),
  Dimension = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID",
  Context = "COST_AND_USAGE"|"RESERVATIONS",
  NextPageToken = "string"
)
}
}

\keyword{internal}
