% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_set_active_receipt_rule_set}
\alias{ses_set_active_receipt_rule_set}
\title{Sets the specified receipt rule set as the active receipt rule set}
\usage{
ses_set_active_receipt_rule_set(RuleSetName)
}
\arguments{
\item{RuleSetName}{The name of the receipt rule set to make active. Setting this value to
null disables all email receiving.}
}
\description{
Sets the specified receipt rule set as the active receipt rule set.
}
\details{
To disable your email-receiving through Amazon SES completely, you can
call this API with RuleSetName set to null.

For information about managing receipt rule sets, see the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$set_active_receipt_rule_set(
  RuleSetName = "string"
)
}
}

\examples{
# The following example sets the active receipt rule set:
\donttest{svc$set_active_receipt_rule_set(
  RuleSetName = "RuleSetToActivate"
)}

}
\keyword{internal}
