% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_user}
\alias{connect_create_user}
\title{Creates a user account for the specified Amazon Connect instance}
\usage{
connect_create_user(Username, Password, IdentityInfo, PhoneConfig,
  DirectoryUserId, SecurityProfileIds, RoutingProfileId, HierarchyGroupId,
  InstanceId, Tags)
}
\arguments{
\item{Username}{[required] The user name for the account. For instances not using SAML for identity
management, the user name can include up to 20 characters. If you are
using SAML for identity management, the user name can include up to 64
characters from [a-zA-Z0-9\\_-.\\@]+.}

\item{Password}{The password for the user account. A password is required if you are
using Amazon Connect for identity management. Otherwise, it is an error
to include a password.}

\item{IdentityInfo}{The information about the identity of the user.}

\item{PhoneConfig}{[required] The phone settings for the user.}

\item{DirectoryUserId}{The identifier of the user account in the directory used for identity
management. If Amazon Connect cannot access the directory, you can
specify this identifier to authenticate users. If you include the
identifier, we assume that Amazon Connect cannot access the directory.
Otherwise, the identity information is used to authenticate users from
your directory.

This parameter is required if you are using an existing directory for
identity management in Amazon Connect when Amazon Connect cannot access
your directory to authenticate users. If you are using SAML for identity
management and include this parameter, an error is returned.}

\item{SecurityProfileIds}{[required] The identifier of the security profile for the user.}

\item{RoutingProfileId}{[required] The identifier of the routing profile for the user.}

\item{HierarchyGroupId}{The identifier of the hierarchy group for the user.}

\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{Tags}{One or more tags.}
}
\description{
Creates a user account for the specified Amazon Connect instance.

For information about how to create user accounts using the Amazon
Connect console, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html}{Add Users}
in the \emph{Amazon Connect Administrator Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_user(
  Username = "string",
  Password = "string",
  IdentityInfo = list(
    FirstName = "string",
    LastName = "string",
    Email = "string"
  ),
  PhoneConfig = list(
    PhoneType = "SOFT_PHONE"|"DESK_PHONE",
    AutoAccept = TRUE|FALSE,
    AfterContactWorkTimeLimit = 123,
    DeskPhoneNumber = "string"
  ),
  DirectoryUserId = "string",
  SecurityProfileIds = list(
    "string"
  ),
  RoutingProfileId = "string",
  HierarchyGroupId = "string",
  InstanceId = "string",
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
