% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_update_contact_attributes}
\alias{connect_update_contact_attributes}
\title{Creates or updates the contact attributes associated with the specified
contact}
\usage{
connect_update_contact_attributes(InitialContactId, InstanceId,
  Attributes)
}
\arguments{
\item{InitialContactId}{[required] The identifier of the contact. This is the identifier of the contact
associated with the first interaction with the contact center.}

\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{Attributes}{[required] The Amazon Connect attributes. These attributes can be accessed in
contact flows just like any other contact attributes.

You can have up to 32,768 UTF-8 bytes across all attributes for a
contact. Attribute keys can include only alphanumeric, dash, and
underscore characters.}
}
\description{
Creates or updates the contact attributes associated with the specified
contact.

You can add or update attributes for both ongoing and completed
contacts. For example, you can update the customer's name or the reason
the customer called while the call is active, or add notes about steps
that the agent took during the call that are displayed to the next agent
that takes the call. You can also update attributes for a contact using
data from your CRM application and save the data with the contact in
Amazon Connect. You could also flag calls for additional analysis, such
as legal review or identifying abusive callers.

Contact attributes are available in Amazon Connect for 24 months, and
are then deleted.

\strong{Important:} You cannot use the operation to update attributes for
contacts that occurred prior to the release of the API, September 12,
2018. You can update attributes only for contacts that started after the
release of the API. If you attempt to update attributes for a contact
that occurred prior to the release of the API, a 400 error is returned.
This applies also to queued callbacks that were initiated prior to the
release of the API but are still active in your instance.
}
\section{Request syntax}{
\preformatted{svc$update_contact_attributes(
  InitialContactId = "string",
  InstanceId = "string",
  Attributes = list(
    "string"
  )
)
}
}

\keyword{internal}
