% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_create_push_template}
\alias{pinpoint_create_push_template}
\title{Creates a message template for messages that are sent through a push
notification channel}
\usage{
pinpoint_create_push_template(PushNotificationTemplateRequest,
  TemplateName)
}
\arguments{
\item{PushNotificationTemplateRequest}{[required]}

\item{TemplateName}{[required] The name of the message template. A template name must start with an
alphanumeric character and can contain a maximum of 128 characters. The
characters can be alphanumeric characters, underscores (\\_), or hyphens
(-). Template names are case sensitive.}
}
\description{
Creates a message template for messages that are sent through a push
notification channel.
}
\section{Request syntax}{
\preformatted{svc$create_push_template(
  PushNotificationTemplateRequest = list(
    ADM = list(
      Action = "OPEN_APP"|"DEEP_LINK"|"URL",
      Body = "string",
      ImageIconUrl = "string",
      ImageUrl = "string",
      RawContent = "string",
      SmallImageIconUrl = "string",
      Sound = "string",
      Title = "string",
      Url = "string"
    ),
    APNS = list(
      Action = "OPEN_APP"|"DEEP_LINK"|"URL",
      Body = "string",
      MediaUrl = "string",
      RawContent = "string",
      Sound = "string",
      Title = "string",
      Url = "string"
    ),
    Baidu = list(
      Action = "OPEN_APP"|"DEEP_LINK"|"URL",
      Body = "string",
      ImageIconUrl = "string",
      ImageUrl = "string",
      RawContent = "string",
      SmallImageIconUrl = "string",
      Sound = "string",
      Title = "string",
      Url = "string"
    ),
    Default = list(
      Action = "OPEN_APP"|"DEEP_LINK"|"URL",
      Body = "string",
      Sound = "string",
      Title = "string",
      Url = "string"
    ),
    DefaultSubstitutions = "string",
    GCM = list(
      Action = "OPEN_APP"|"DEEP_LINK"|"URL",
      Body = "string",
      ImageIconUrl = "string",
      ImageUrl = "string",
      RawContent = "string",
      SmallImageIconUrl = "string",
      Sound = "string",
      Title = "string",
      Url = "string"
    ),
    RecommenderId = "string",
    tags = list(
      "string"
    ),
    TemplateDescription = "string"
  ),
  TemplateName = "string"
)
}
}

\keyword{internal}
