% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_verify_email_identity}
\alias{ses_verify_email_identity}
\title{Adds an email address to the list of identities for your Amazon SES
account in the current AWS region and attempts to verify it}
\usage{
ses_verify_email_identity(EmailAddress)
}
\arguments{
\item{EmailAddress}{[required] The email address to be verified.}
}
\description{
Adds an email address to the list of identities for your Amazon SES
account in the current AWS region and attempts to verify it. As a result
of executing this operation, a verification email is sent to the
specified address.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$verify_email_identity(
  EmailAddress = "string"
)
}
}

\examples{
\dontrun{
# The following example starts the email address verification process with
# Amazon SES:
svc$verify_email_identity(
  EmailAddress = "user@example.com"
)
}

}
\keyword{internal}
