% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointsmsvoice_operations.R
\name{pinpointsmsvoice_update_configuration_set_event_destination}
\alias{pinpointsmsvoice_update_configuration_set_event_destination}
\title{Update an event destination in a configuration set}
\usage{
pinpointsmsvoice_update_configuration_set_event_destination(
  ConfigurationSetName, EventDestination, EventDestinationName)
}
\arguments{
\item{ConfigurationSetName}{[required] ConfigurationSetName}

\item{EventDestination}{}

\item{EventDestinationName}{[required] EventDestinationName}
}
\value{
An empty list.
}
\description{
Update an event destination in a configuration set. An event destination
is a location that you publish information about your voice calls to.
For example, you can log an event to an Amazon CloudWatch destination
when a call fails.
}
\section{Request syntax}{
\preformatted{svc$update_configuration_set_event_destination(
  ConfigurationSetName = "string",
  EventDestination = list(
    CloudWatchLogsDestination = list(
      IamRoleArn = "string",
      LogGroupArn = "string"
    ),
    Enabled = TRUE|FALSE,
    KinesisFirehoseDestination = list(
      DeliveryStreamArn = "string",
      IamRoleArn = "string"
    ),
    MatchingEventTypes = list(
      "INITIATED_CALL"|"RINGING"|"ANSWERED"|"COMPLETED_CALL"|"BUSY"|"FAILED"|"NO_ANSWER"
    ),
    SnsDestination = list(
      TopicArn = "string"
    )
  ),
  EventDestinationName = "string"
)
}
}

\keyword{internal}
