% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_get_segments}
\alias{pinpoint_get_segments}
\title{Retrieves information about the configuration, dimension, and other
settings for all the segments that are associated with an application}
\usage{
pinpoint_get_segments(ApplicationId, PageSize, Token)
}
\arguments{
\item{ApplicationId}{[required] The unique identifier for the application. This identifier is displayed
as the \strong{Project ID} on the Amazon Pinpoint console.}

\item{PageSize}{The maximum number of items to include in each page of a paginated
response. This parameter is not supported for application, campaign, and
journey metrics.}

\item{Token}{The NextToken string that specifies which page of results to return in a
paginated response.}
}
\value{
A list with the following syntax:\preformatted{list(
  SegmentsResponse = list(
    Item = list(
      list(
        ApplicationId = "string",
        Arn = "string",
        CreationDate = "string",
        Dimensions = list(
          Attributes = list(
            list(
              AttributeType = "INCLUSIVE"|"EXCLUSIVE",
              Values = list(
                "string"
              )
            )
          ),
          Behavior = list(
            Recency = list(
              Duration = "HR_24"|"DAY_7"|"DAY_14"|"DAY_30",
              RecencyType = "ACTIVE"|"INACTIVE"
            )
          ),
          Demographic = list(
            AppVersion = list(
              DimensionType = "INCLUSIVE"|"EXCLUSIVE",
              Values = list(
                "string"
              )
            ),
            Channel = list(
              DimensionType = "INCLUSIVE"|"EXCLUSIVE",
              Values = list(
                "string"
              )
            ),
            DeviceType = list(
              DimensionType = "INCLUSIVE"|"EXCLUSIVE",
              Values = list(
                "string"
              )
            ),
            Make = list(
              DimensionType = "INCLUSIVE"|"EXCLUSIVE",
              Values = list(
                "string"
              )
            ),
            Model = list(
              DimensionType = "INCLUSIVE"|"EXCLUSIVE",
              Values = list(
                "string"
              )
            ),
            Platform = list(
              DimensionType = "INCLUSIVE"|"EXCLUSIVE",
              Values = list(
                "string"
              )
            )
          ),
          Location = list(
            Country = list(
              DimensionType = "INCLUSIVE"|"EXCLUSIVE",
              Values = list(
                "string"
              )
            ),
            GPSPoint = list(
              Coordinates = list(
                Latitude = 123.0,
                Longitude = 123.0
              ),
              RangeInKilometers = 123.0
            )
          ),
          Metrics = list(
            list(
              ComparisonOperator = "string",
              Value = 123.0
            )
          ),
          UserAttributes = list(
            list(
              AttributeType = "INCLUSIVE"|"EXCLUSIVE",
              Values = list(
                "string"
              )
            )
          )
        ),
        Id = "string",
        ImportDefinition = list(
          ChannelCounts = list(
            123
          ),
          ExternalId = "string",
          Format = "CSV"|"JSON",
          RoleArn = "string",
          S3Url = "string",
          Size = 123
        ),
        LastModifiedDate = "string",
        Name = "string",
        SegmentGroups = list(
          Groups = list(
            list(
              Dimensions = list(
                list(
                  Attributes = list(
                    list(
                      AttributeType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    )
                  ),
                  Behavior = list(
                    Recency = list(
                      Duration = "HR_24"|"DAY_7"|"DAY_14"|"DAY_30",
                      RecencyType = "ACTIVE"|"INACTIVE"
                    )
                  ),
                  Demographic = list(
                    AppVersion = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Channel = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    DeviceType = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Make = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Model = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Platform = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    )
                  ),
                  Location = list(
                    Country = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    GPSPoint = list(
                      Coordinates = list(
                        Latitude = 123.0,
                        Longitude = 123.0
                      ),
                      RangeInKilometers = 123.0
                    )
                  ),
                  Metrics = list(
                    list(
                      ComparisonOperator = "string",
                      Value = 123.0
                    )
                  ),
                  UserAttributes = list(
                    list(
                      AttributeType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    )
                  )
                )
              ),
              SourceSegments = list(
                list(
                  Id = "string",
                  Version = 123
                )
              ),
              SourceType = "ALL"|"ANY"|"NONE",
              Type = "ALL"|"ANY"|"NONE"
            )
          ),
          Include = "ALL"|"ANY"|"NONE"
        ),
        SegmentType = "DIMENSIONAL"|"IMPORT",
        tags = list(
          "string"
        ),
        Version = 123
      )
    ),
    NextToken = "string"
  )
)
}
}
\description{
Retrieves information about the configuration, dimension, and other
settings for all the segments that are associated with an application.
}
\section{Request syntax}{
\preformatted{svc$get_segments(
  ApplicationId = "string",
  PageSize = "string",
  Token = "string"
)
}
}

\keyword{internal}
