# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Pinpoint SMS and Voice Service
#'
#' @description
#' Pinpoint SMS and Voice Messaging public facing APIs
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- pinpointsmsvoice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- pinpointsmsvoice()
#' svc$create_configuration_set(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=pinpointsmsvoice_create_configuration_set]{create_configuration_set} \tab Create a new configuration set \cr
#'  \link[=pinpointsmsvoice_create_configuration_set_event_destination]{create_configuration_set_event_destination} \tab Create a new event destination in a configuration set \cr
#'  \link[=pinpointsmsvoice_delete_configuration_set]{delete_configuration_set} \tab Deletes an existing configuration set \cr
#'  \link[=pinpointsmsvoice_delete_configuration_set_event_destination]{delete_configuration_set_event_destination} \tab Deletes an event destination in a configuration set \cr
#'  \link[=pinpointsmsvoice_get_configuration_set_event_destinations]{get_configuration_set_event_destinations} \tab Obtain information about an event destination, including the types of events it reports, the Amazon Resource Name (ARN) of the destination, and the name of the event destination\cr
#'  \link[=pinpointsmsvoice_list_configuration_sets]{list_configuration_sets} \tab List all of the configuration sets associated with your Amazon Pinpoint account in the current region \cr
#'  \link[=pinpointsmsvoice_send_voice_message]{send_voice_message} \tab Create a new voice message and send it to a recipient's phone number \cr
#'  \link[=pinpointsmsvoice_update_configuration_set_event_destination]{update_configuration_set_event_destination} \tab Update an event destination in a configuration set 
#' }
#'
#' @rdname pinpointsmsvoice
#' @export
pinpointsmsvoice <- function(config = list()) {
  svc <- .pinpointsmsvoice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.pinpointsmsvoice <- list()

.pinpointsmsvoice$operations <- list()

.pinpointsmsvoice$metadata <- list(
  service_name = "pinpointsmsvoice",
  endpoints = list("*" = list(endpoint = "pinpointsmsvoice.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "pinpointsmsvoice.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "pinpointsmsvoice.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "pinpointsmsvoice.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Pinpoint SMS Voice",
  api_version = "2018-09-05",
  signing_name = "sms-voice",
  json_version = "1.1",
  target_prefix = ""
)

.pinpointsmsvoice$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.pinpointsmsvoice$metadata, handlers, config)
}
