% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_monitor_contact}
\alias{connect_monitor_contact}
\title{Initiates silent monitoring of a contact}
\usage{
connect_monitor_contact(
  InstanceId,
  ContactId,
  UserId,
  AllowedMonitorCapabilities = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can find the
instanceId in the ARN of the instance.}

\item{ContactId}{[required] The identifier of the contact.}

\item{UserId}{[required] The identifier of the user account.}

\item{AllowedMonitorCapabilities}{Specify which monitoring actions the user is allowed to take. For
example, whether the user is allowed to escalate from silent monitoring
to barge. AllowedMonitorCapabilities is required if barge is enabled.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}
}
\description{
Initiates silent monitoring of a contact. The Contact Control Panel (CCP) of the user specified by \emph{userId} will be set to silent monitoring mode on the contact.

See \url{https://www.paws-r-sdk.com/docs/connect_monitor_contact/} for full documentation.
}
\keyword{internal}
