% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointsmsvoicev2_operations.R
\name{pinpointsmsvoicev2_create_registration_attachment}
\alias{pinpointsmsvoicev2_create_registration_attachment}
\title{Create a new registration attachment to use for uploading a file or a
URL to a file}
\usage{
pinpointsmsvoicev2_create_registration_attachment(
  AttachmentBody = NULL,
  AttachmentUrl = NULL,
  Tags = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{AttachmentBody}{The registration file to upload. The maximum file size is 500KB and
valid file extensions are PDF, JPEG and PNG.}

\item{AttachmentUrl}{Registration files have to be stored in an Amazon S3 bucket. The URI to
use when sending is in the format \verb{s3://BucketName/FileName}.}

\item{Tags}{An array of tags (key and value pairs) to associate with the
registration attachment.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If you don't specify a client token, a
randomly generated token is used for the request to ensure idempotency.}
}
\description{
Create a new registration attachment to use for uploading a file or a URL to a file. The maximum file size is 500KB and valid file extensions are PDF, JPEG and PNG. For example, many sender ID registrations require a signed “letter of authorization” (LOA) to be submitted.

See \url{https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_create_registration_attachment/} for full documentation.
}
\keyword{internal}
