% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_delete_db_instance}
\alias{rds_delete_db_instance}
\title{The DeleteDBInstance action deletes a previously provisioned DB instance}
\usage{
rds_delete_db_instance(DBInstanceIdentifier, SkipFinalSnapshot,
  FinalDBSnapshotIdentifier, DeleteAutomatedBackups)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The DB instance identifier for the DB instance to be deleted. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must match the name of an existing DB instance.
}}

\item{SkipFinalSnapshot}{A value that indicates whether a final DB snapshot is created before the
DB instance is deleted. If \code{true} is specified, no DB snapshot is
created. If \code{false} is specified, a DB snapshot is created before the DB
instance is deleted.

When a DB instance is in a failure state and has a status of \code{failed},
\code{incompatible-restore}, or \code{incompatible-network}, you can only delete
it when the \code{SkipFinalSnapshot} parameter is set to \code{true}.

Specify \code{true} when deleting a Read Replica.

The \code{FinalDBSnapshotIdentifier} parameter must be specified if
\code{SkipFinalSnapshot} is \code{false}.

Default: \code{false}}

\item{FinalDBSnapshotIdentifier}{The \code{DBSnapshotIdentifier} of the new DB snapshot created when
\code{SkipFinalSnapshot} is set to \code{false}.

Specifying this parameter and also setting the \code{SkipFinalShapshot}
parameter to \code{true} results in an error.

Constraints:
\itemize{
\item Must be 1 to 255 letters or numbers.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
\item Can't be specified when deleting a Read Replica.
}}

\item{DeleteAutomatedBackups}{A value that indicates whether to remove automated backups immediately
after the DB instance is deleted. This parameter isn't case-sensitive.
This parameter defaults to \code{true}.}
}
\description{
The DeleteDBInstance action deletes a previously provisioned DB
instance. When you delete a DB instance, all automated backups for that
instance are deleted and can't be recovered. Manual DB snapshots of the
DB instance to be deleted by \code{DeleteDBInstance} are not deleted.
}
\details{
If you request a final DB snapshot the status of the Amazon RDS DB
instance is \code{deleting} until the DB snapshot is created. The API action
\code{DescribeDBInstance} is used to monitor the status of this operation.
The action can't be canceled or reverted once submitted.

Note that when a DB instance is in a failure state and has a status of
\code{failed}, \code{incompatible-restore}, or \code{incompatible-network}, you can
only delete it when the \code{SkipFinalSnapshot} parameter is set to \code{true}.

If the specified DB instance is part of an Amazon Aurora DB cluster, you
can't delete the DB instance if both of the following conditions are
true:
\itemize{
\item The DB cluster is a Read Replica of another Amazon Aurora DB
cluster.
\item The DB instance is the only instance in the DB cluster.
}

To delete a DB instance in this case, first call the
PromoteReadReplicaDBCluster API action to promote the DB cluster so
it's no longer a Read Replica. After the promotion completes, then call
the \code{DeleteDBInstance} API action to delete the final instance in the DB
cluster.
}
\section{Request syntax}{
\preformatted{svc$delete_db_instance(
  DBInstanceIdentifier = "string",
  SkipFinalSnapshot = TRUE|FALSE,
  FinalDBSnapshotIdentifier = "string",
  DeleteAutomatedBackups = TRUE|FALSE
)
}
}

\keyword{internal}
