% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_describe_table}
\alias{dynamodb_describe_table}
\title{Returns information about the table, including the current status of the
table, when it was created, the primary key schema, and any indexes on
the table}
\usage{
dynamodb_describe_table(TableName)
}
\arguments{
\item{TableName}{[required] The name of the table to describe.}
}
\description{
Returns information about the table, including the current status of the
table, when it was created, the primary key schema, and any indexes on
the table.

If you issue a \code{DescribeTable} request immediately after a \code{CreateTable}
request, DynamoDB might return a \code{ResourceNotFoundException}. This is
because \code{DescribeTable} uses an eventually consistent query, and the
metadata for your table might not be available at that moment. Wait for
a few seconds, and then try the \code{DescribeTable} request again.
}
\section{Request syntax}{
\preformatted{svc$describe_table(
  TableName = "string"
)
}
}

\examples{
\dontrun{
# This example describes the Music table.
svc$describe_table(
  TableName = "Music"
)
}

}
\keyword{internal}
