% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_update_table_replica_auto_scaling}
\alias{dynamodb_update_table_replica_auto_scaling}
\title{Updates auto scaling settings on your global tables at once}
\usage{
dynamodb_update_table_replica_auto_scaling(GlobalSecondaryIndexUpdates,
  TableName, ProvisionedWriteCapacityAutoScalingUpdate, ReplicaUpdates)
}
\arguments{
\item{GlobalSecondaryIndexUpdates}{Represents the auto scaling settings of the global secondary indexes of
the replica to be updated.}

\item{TableName}{[required] The name of the global table to be updated.}

\item{ProvisionedWriteCapacityAutoScalingUpdate}{}

\item{ReplicaUpdates}{Represents the auto scaling settings of replicas of the table that will
be modified.}
}
\description{
Updates auto scaling settings on your global tables at once.

This operation only applies to \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html}{Version 2019.11.21}
of global tables.
}
\section{Request syntax}{
\preformatted{svc$update_table_replica_auto_scaling(
  GlobalSecondaryIndexUpdates = list(
    list(
      IndexName = "string",
      ProvisionedWriteCapacityAutoScalingUpdate = list(
        MinimumUnits = 123,
        MaximumUnits = 123,
        AutoScalingDisabled = TRUE|FALSE,
        AutoScalingRoleArn = "string",
        ScalingPolicyUpdate = list(
          PolicyName = "string",
          TargetTrackingScalingPolicyConfiguration = list(
            DisableScaleIn = TRUE|FALSE,
            ScaleInCooldown = 123,
            ScaleOutCooldown = 123,
            TargetValue = 123.0
          )
        )
      )
    )
  ),
  TableName = "string",
  ProvisionedWriteCapacityAutoScalingUpdate = list(
    MinimumUnits = 123,
    MaximumUnits = 123,
    AutoScalingDisabled = TRUE|FALSE,
    AutoScalingRoleArn = "string",
    ScalingPolicyUpdate = list(
      PolicyName = "string",
      TargetTrackingScalingPolicyConfiguration = list(
        DisableScaleIn = TRUE|FALSE,
        ScaleInCooldown = 123,
        ScaleOutCooldown = 123,
        TargetValue = 123.0
      )
    )
  ),
  ReplicaUpdates = list(
    list(
      RegionName = "string",
      ReplicaGlobalSecondaryIndexUpdates = list(
        list(
          IndexName = "string",
          ProvisionedReadCapacityAutoScalingUpdate = list(
            MinimumUnits = 123,
            MaximumUnits = 123,
            AutoScalingDisabled = TRUE|FALSE,
            AutoScalingRoleArn = "string",
            ScalingPolicyUpdate = list(
              PolicyName = "string",
              TargetTrackingScalingPolicyConfiguration = list(
                DisableScaleIn = TRUE|FALSE,
                ScaleInCooldown = 123,
                ScaleOutCooldown = 123,
                TargetValue = 123.0
              )
            )
          )
        )
      ),
      ReplicaProvisionedReadCapacityAutoScalingUpdate = list(
        MinimumUnits = 123,
        MaximumUnits = 123,
        AutoScalingDisabled = TRUE|FALSE,
        AutoScalingRoleArn = "string",
        ScalingPolicyUpdate = list(
          PolicyName = "string",
          TargetTrackingScalingPolicyConfiguration = list(
            DisableScaleIn = TRUE|FALSE,
            ScaleInCooldown = 123,
            ScaleOutCooldown = 123,
            TargetValue = 123.0
          )
        )
      )
    )
  )
)
}
}

\keyword{internal}
