% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdsdataservice_operations.R
\name{rdsdataservice_begin_transaction}
\alias{rdsdataservice_begin_transaction}
\title{Starts a SQL transaction}
\usage{
rdsdataservice_begin_transaction(database, resourceArn, schema,
  secretArn)
}
\arguments{
\item{database}{The name of the database.}

\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.}

\item{schema}{The name of the database schema.}

\item{secretArn}{[required] The name or ARN of the secret that enables access to the DB cluster.}
}
\description{
Starts a SQL transaction.\preformatted{ &lt;important&gt; &lt;p&gt;A transaction can run for a maximum of 24 hours. A transaction is terminated and rolled back automatically after 24 hours.&lt;/p&gt; &lt;p&gt;A transaction times out if no calls use its transaction ID in three minutes. If a transaction times out before it's committed, it's rolled back automatically.&lt;/p&gt; &lt;p&gt;DDL statements inside a transaction cause an implicit commit. We recommend that you run each DDL statement in a separate &lt;code&gt;ExecuteStatement&lt;/code&gt; call with &lt;code&gt;continueAfterTimeout&lt;/code&gt; enabled.&lt;/p&gt; &lt;/important&gt; 
}
}
\section{Request syntax}{
\preformatted{svc$begin_transaction(
  database = "string",
  resourceArn = "string",
  schema = "string",
  secretArn = "string"
)
}
}

\keyword{internal}
