% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_delete_db_instance}
\alias{neptune_delete_db_instance}
\title{The DeleteDBInstance action deletes a previously provisioned DB instance}
\usage{
neptune_delete_db_instance(DBInstanceIdentifier, SkipFinalSnapshot,
  FinalDBSnapshotIdentifier)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The DB instance identifier for the DB instance to be deleted. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must match the name of an existing DB instance.
}}

\item{SkipFinalSnapshot}{Determines whether a final DB snapshot is created before the DB instance
is deleted. If \code{true} is specified, no DBSnapshot is created. If \code{false}
is specified, a DB snapshot is created before the DB instance is
deleted.

Note that when a DB instance is in a failure state and has a status of
'failed', 'incompatible-restore', or 'incompatible-network', it can only
be deleted when the SkipFinalSnapshot parameter is set to "true".

Specify \code{true} when deleting a Read Replica.

The FinalDBSnapshotIdentifier parameter must be specified if
SkipFinalSnapshot is \code{false}.

Default: \code{false}}

\item{FinalDBSnapshotIdentifier}{The DBSnapshotIdentifier of the new DBSnapshot created when
SkipFinalSnapshot is set to \code{false}.

Specifying this parameter and also setting the SkipFinalShapshot
parameter to true results in an error.

Constraints:
\itemize{
\item Must be 1 to 255 letters or numbers.
\item First character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
\item Cannot be specified when deleting a Read Replica.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  DBInstance = list(
    DBInstanceIdentifier = "string",
    DBInstanceClass = "string",
    Engine = "string",
    DBInstanceStatus = "string",
    MasterUsername = "string",
    DBName = "string",
    Endpoint = list(
      Address = "string",
      Port = 123,
      HostedZoneId = "string"
    ),
    AllocatedStorage = 123,
    InstanceCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    PreferredBackupWindow = "string",
    BackupRetentionPeriod = 123,
    DBSecurityGroups = list(
      list(
        DBSecurityGroupName = "string",
        Status = "string"
      )
    ),
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    DBParameterGroups = list(
      list(
        DBParameterGroupName = "string",
        ParameterApplyStatus = "string"
      )
    ),
    AvailabilityZone = "string",
    DBSubnetGroup = list(
      DBSubnetGroupName = "string",
      DBSubnetGroupDescription = "string",
      VpcId = "string",
      SubnetGroupStatus = "string",
      Subnets = list(
        list(
          SubnetIdentifier = "string",
          SubnetAvailabilityZone = list(
            Name = "string"
          ),
          SubnetStatus = "string"
        )
      ),
      DBSubnetGroupArn = "string"
    ),
    PreferredMaintenanceWindow = "string",
    PendingModifiedValues = list(
      DBInstanceClass = "string",
      AllocatedStorage = 123,
      MasterUserPassword = "string",
      Port = 123,
      BackupRetentionPeriod = 123,
      MultiAZ = TRUE|FALSE,
      EngineVersion = "string",
      LicenseModel = "string",
      Iops = 123,
      DBInstanceIdentifier = "string",
      StorageType = "string",
      CACertificateIdentifier = "string",
      DBSubnetGroupName = "string",
      PendingCloudwatchLogsExports = list(
        LogTypesToEnable = list(
          "string"
        ),
        LogTypesToDisable = list(
          "string"
        )
      )
    ),
    LatestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    MultiAZ = TRUE|FALSE,
    EngineVersion = "string",
    AutoMinorVersionUpgrade = TRUE|FALSE,
    ReadReplicaSourceDBInstanceIdentifier = "string",
    ReadReplicaDBInstanceIdentifiers = list(
      "string"
    ),
    ReadReplicaDBClusterIdentifiers = list(
      "string"
    ),
    LicenseModel = "string",
    Iops = 123,
    OptionGroupMemberships = list(
      list(
        OptionGroupName = "string",
        Status = "string"
      )
    ),
    CharacterSetName = "string",
    SecondaryAvailabilityZone = "string",
    PubliclyAccessible = TRUE|FALSE,
    StatusInfos = list(
      list(
        StatusType = "string",
        Normal = TRUE|FALSE,
        Status = "string",
        Message = "string"
      )
    ),
    StorageType = "string",
    TdeCredentialArn = "string",
    DbInstancePort = 123,
    DBClusterIdentifier = "string",
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DbiResourceId = "string",
    CACertificateIdentifier = "string",
    DomainMemberships = list(
      list(
        Domain = "string",
        Status = "string",
        FQDN = "string",
        IAMRoleName = "string"
      )
    ),
    CopyTagsToSnapshot = TRUE|FALSE,
    MonitoringInterval = 123,
    EnhancedMonitoringResourceArn = "string",
    MonitoringRoleArn = "string",
    PromotionTier = 123,
    DBInstanceArn = "string",
    Timezone = "string",
    IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
    PerformanceInsightsEnabled = TRUE|FALSE,
    PerformanceInsightsKMSKeyId = "string",
    EnabledCloudwatchLogsExports = list(
      "string"
    ),
    DeletionProtection = TRUE|FALSE
  )
)
}
}
\description{
The DeleteDBInstance action deletes a previously provisioned DB
instance. When you delete a DB instance, all automated backups for that
instance are deleted and can't be recovered. Manual DB snapshots of the
DB instance to be deleted by
\code{\link[=neptune_delete_db_instance]{delete_db_instance}} are not deleted.

If you request a final DB snapshot the status of the Amazon Neptune DB
instance is \code{deleting} until the DB snapshot is created. The API action
\code{DescribeDBInstance} is used to monitor the status of this operation.
The action can't be canceled or reverted once submitted.

Note that when a DB instance is in a failure state and has a status of
\code{failed}, \code{incompatible-restore}, or \code{incompatible-network}, you can
only delete it when the \code{SkipFinalSnapshot} parameter is set to \code{true}.

You can't delete a DB instance if it is the only instance in the DB
cluster, or if it has deletion protection enabled.
}
\section{Request syntax}{
\preformatted{svc$delete_db_instance(
  DBInstanceIdentifier = "string",
  SkipFinalSnapshot = TRUE|FALSE,
  FinalDBSnapshotIdentifier = "string"
)
}
}

\keyword{internal}
