% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_disable_logging}
\alias{redshift_disable_logging}
\title{Stops logging information, such as queries and connection attempts, for
the specified Amazon Redshift cluster}
\usage{
redshift_disable_logging(ClusterIdentifier)
}
\arguments{
\item{ClusterIdentifier}{[required] The identifier of the cluster on which logging is to be stopped.

Example: \code{examplecluster}}
}
\value{
A list with the following syntax:\preformatted{list(
  LoggingEnabled = TRUE|FALSE,
  BucketName = "string",
  S3KeyPrefix = "string",
  LastSuccessfulDeliveryTime = as.POSIXct(
    "2015-01-01"
  ),
  LastFailureTime = as.POSIXct(
    "2015-01-01"
  ),
  LastFailureMessage = "string"
)
}
}
\description{
Stops logging information, such as queries and connection attempts, for
the specified Amazon Redshift cluster.
}
\section{Request syntax}{
\preformatted{svc$disable_logging(
  ClusterIdentifier = "string"
)
}
}

\keyword{internal}
