% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_create_global_table}
\alias{dynamodb_create_global_table}
\title{Creates a global table from an existing table}
\usage{
dynamodb_create_global_table(GlobalTableName, ReplicationGroup)
}
\arguments{
\item{GlobalTableName}{[required] The global table name.}

\item{ReplicationGroup}{[required] The Regions where the global table needs to be created.}
}
\description{
Creates a global table from an existing table. A global table creates a
replication relationship between two or more DynamoDB tables with the
same table name in the provided Regions.
}
\details{
If you want to add a new replica table to a global table, each of the
following conditions must be true:
\itemize{
\item The table must have the same primary key as all of the other
replicas.
\item The table must have the same name as all of the other replicas.
\item The table must have DynamoDB Streams enabled, with the stream
containing both the new and the old images of the item.
\item None of the replica tables in the global table can contain any data.
}

If global secondary indexes are specified, then the following conditions
must also be met:
\itemize{
\item The global secondary indexes must have the same name.
\item The global secondary indexes must have the same hash key and sort
key (if present).
}

Write capacity settings should be set consistently across your replica
tables and secondary indexes. DynamoDB strongly recommends enabling auto
scaling to manage the write capacity settings for all of your global
tables replicas and indexes.

If you prefer to manage write capacity settings manually, you should
provision equal replicated write capacity units to your replica tables.
You should also provision equal replicated write capacity units to
matching secondary indexes across your global table.
}
\section{Request syntax}{
\preformatted{svc$create_global_table(
  GlobalTableName = "string",
  ReplicationGroup = list(
    list(
      RegionName = "string"
    )
  )
)
}
}

\keyword{internal}
