% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_describe_cache_parameters}
\alias{elasticache_describe_cache_parameters}
\title{Returns the detailed parameter list for a particular cache parameter
group}
\usage{
elasticache_describe_cache_parameters(CacheParameterGroupName, Source,
  MaxRecords, Marker)
}
\arguments{
\item{CacheParameterGroupName}{[required] The name of a specific cache parameter group to return details for.}

\item{Source}{The parameter types to return.

Valid values: \code{user} \| \code{system} \| \code{engine-default}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a marker is
included in the response so that the remaining results can be retrieved.

Default: 100

Constraints: minimum 20; maximum 100.}

\item{Marker}{An optional marker returned from a prior request. Use this marker for
pagination of results from this operation. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords}.}
}
\description{
Returns the detailed parameter list for a particular cache parameter
group.
}
\section{Request syntax}{
\preformatted{svc$describe_cache_parameters(
  CacheParameterGroupName = "string",
  Source = "string",
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
