% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_restore_from_cluster_snapshot}
\alias{redshift_restore_from_cluster_snapshot}
\title{Creates a new cluster from a snapshot}
\usage{
redshift_restore_from_cluster_snapshot(ClusterIdentifier,
  SnapshotIdentifier, SnapshotClusterIdentifier, Port, AvailabilityZone,
  AllowVersionUpgrade, ClusterSubnetGroupName, PubliclyAccessible,
  OwnerAccount, HsmClientCertificateIdentifier,
  HsmConfigurationIdentifier, ElasticIp, ClusterParameterGroupName,
  ClusterSecurityGroups, VpcSecurityGroupIds, PreferredMaintenanceWindow,
  AutomatedSnapshotRetentionPeriod, ManualSnapshotRetentionPeriod,
  KmsKeyId, NodeType, EnhancedVpcRouting, AdditionalInfo, IamRoles,
  MaintenanceTrackName, SnapshotScheduleIdentifier, NumberOfNodes)
}
\arguments{
\item{ClusterIdentifier}{[required] The identifier of the cluster that will be created from restoring the
snapshot.

Constraints:
\itemize{
\item Must contain from 1 to 63 alphanumeric characters or hyphens.
\item Alphabetic characters must be lowercase.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
\item Must be unique for all clusters within an AWS account.
}}

\item{SnapshotIdentifier}{[required] The name of the snapshot from which to create the new cluster. This
parameter isn\'t case sensitive.

Example: \code{my-snapshot-id}}

\item{SnapshotClusterIdentifier}{The name of the cluster the source snapshot was created from. This
parameter is required if your IAM user has a policy containing a
snapshot resource element that specifies anything other than \* for the
cluster name.}

\item{Port}{The port number on which the cluster accepts connections.

Default: The same port as the original cluster.

Constraints: Must be between \code{1115} and \code{65535}.}

\item{AvailabilityZone}{The Amazon EC2 Availability Zone in which to restore the cluster.

Default: A random, system-chosen Availability Zone.

Example: \verb{us-east-1a}}

\item{AllowVersionUpgrade}{If \code{true}, major version upgrades can be applied during the maintenance
window to the Amazon Redshift engine that is running on the cluster.

Default: \code{true}}

\item{ClusterSubnetGroupName}{The name of the subnet group where you want to cluster restored.

A snapshot of cluster in VPC can be restored only in VPC. Therefore, you
must provide subnet group name where you want the cluster restored.}

\item{PubliclyAccessible}{If \code{true}, the cluster can be accessed from a public network.}

\item{OwnerAccount}{The AWS customer account used to create or copy the snapshot. Required
if you are restoring a snapshot you do not own, optional if you own the
snapshot.}

\item{HsmClientCertificateIdentifier}{Specifies the name of the HSM client certificate the Amazon Redshift
cluster uses to retrieve the data encryption keys stored in an HSM.}

\item{HsmConfigurationIdentifier}{Specifies the name of the HSM configuration that contains the
information the Amazon Redshift cluster can use to retrieve and store
keys in an HSM.}

\item{ElasticIp}{The elastic IP (EIP) address for the cluster.}

\item{ClusterParameterGroupName}{The name of the parameter group to be associated with this cluster.

Default: The default Amazon Redshift cluster parameter group. For
information about the default parameter group, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html}{Working with Amazon Redshift Parameter Groups}.

Constraints:
\itemize{
\item Must be 1 to 255 alphanumeric characters or hyphens.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}}

\item{ClusterSecurityGroups}{A list of security groups to be associated with this cluster.

Default: The default cluster security group for Amazon Redshift.

Cluster security groups only apply to clusters outside of VPCs.}

\item{VpcSecurityGroupIds}{A list of Virtual Private Cloud (VPC) security groups to be associated
with the cluster.

Default: The default VPC security group is associated with the cluster.

VPC security groups only apply to clusters in VPCs.}

\item{PreferredMaintenanceWindow}{The weekly time range (in UTC) during which automated cluster
maintenance can occur.

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

Default: The value selected for the cluster from which the snapshot was
taken. For more information about the time blocks for each region, see
\href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows}{Maintenance Windows}
in Amazon Redshift Cluster Management Guide.

Valid Days: Mon \\| Tue \\| Wed \\| Thu \\| Fri \\| Sat \\| Sun

Constraints: Minimum 30-minute window.}

\item{AutomatedSnapshotRetentionPeriod}{The number of days that automated snapshots are retained. If the value
is 0, automated snapshots are disabled. Even if automated snapshots are
disabled, you can still create manual snapshots when you want with
CreateClusterSnapshot.

Default: The value selected for the cluster from which the snapshot was
taken.

Constraints: Must be a value from 0 to 35.}

\item{ManualSnapshotRetentionPeriod}{The default number of days to retain a manual snapshot. If the value is
-1, the snapshot is retained indefinitely. This setting doesn\'t change
the retention period of existing snapshots.

The value must be either -1 or an integer between 1 and 3,653.}

\item{KmsKeyId}{The AWS Key Management Service (KMS) key ID of the encryption key that
you want to use to encrypt data in the cluster that you restore from a
shared snapshot.}

\item{NodeType}{The node type that the restored cluster will be provisioned with.

Default: The node type of the cluster from which the snapshot was taken.
You can modify this if you are using any DS node type. In that case, you
can choose to restore into another DS node type of the same size. For
example, you can restore ds1.8xlarge into ds2.8xlarge, or ds1.xlarge
into ds2.xlarge. If you have a DC instance type, you must restore into
that same instance type and size. In other words, you can only restore a
dc1.large instance type into another dc1.large instance type or
dc2.large instance type. You can\'t restore dc1.8xlarge to dc2.8xlarge.
First restore to a dc1.8xlareg cluster, then resize to a dc2.8large
cluster. For more information about node types, see \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes}{About Clusters and Nodes}
in the \emph{Amazon Redshift Cluster Management Guide}.}

\item{EnhancedVpcRouting}{An option that specifies whether to create the cluster with enhanced VPC
routing enabled. To create a cluster that uses enhanced VPC routing, the
cluster must be in a VPC. For more information, see \href{https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html}{Enhanced VPC Routing}
in the Amazon Redshift Cluster Management Guide.

If this option is \code{true}, enhanced VPC routing is enabled.

Default: false}

\item{AdditionalInfo}{Reserved.}

\item{IamRoles}{A list of AWS Identity and Access Management (IAM) roles that can be
used by the cluster to access other AWS services. You must supply the
IAM roles in their Amazon Resource Name (ARN) format. You can supply up
to 10 IAM roles in a single request.

A cluster can have up to 10 IAM roles associated at any time.}

\item{MaintenanceTrackName}{The name of the maintenance track for the restored cluster. When you
take a snapshot, the snapshot inherits the \code{MaintenanceTrack} value from
the cluster. The snapshot might be on a different track than the cluster
that was the source for the snapshot. For example, suppose that you take
a snapshot of a cluster that is on the current track and then change the
cluster to be on the trailing track. In this case, the snapshot and the
source cluster are on different tracks.}

\item{SnapshotScheduleIdentifier}{A unique identifier for the snapshot schedule.}

\item{NumberOfNodes}{The number of nodes specified when provisioning the restored cluster.}
}
\description{
Creates a new cluster from a snapshot. By default, Amazon Redshift
creates the resulting cluster with the same configuration as the
original cluster from which the snapshot was created, except that the
new cluster is created with the default cluster security and parameter
groups. After Amazon Redshift creates the cluster, you can use the
ModifyCluster API to associate a different security group and different
parameter group with the restored cluster. If you are using a DS node
type, you can also choose to change to another DS node type of the same
size during restore.
}
\details{
If you restore a cluster into a VPC, you must provide a cluster subnet
group where you want the cluster restored.

For more information about working with snapshots, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html}{Amazon Redshift Snapshots}
in the \emph{Amazon Redshift Cluster Management Guide}.
}
\section{Request syntax}{
\preformatted{svc$restore_from_cluster_snapshot(
  ClusterIdentifier = "string",
  SnapshotIdentifier = "string",
  SnapshotClusterIdentifier = "string",
  Port = 123,
  AvailabilityZone = "string",
  AllowVersionUpgrade = TRUE|FALSE,
  ClusterSubnetGroupName = "string",
  PubliclyAccessible = TRUE|FALSE,
  OwnerAccount = "string",
  HsmClientCertificateIdentifier = "string",
  HsmConfigurationIdentifier = "string",
  ElasticIp = "string",
  ClusterParameterGroupName = "string",
  ClusterSecurityGroups = list(
    "string"
  ),
  VpcSecurityGroupIds = list(
    "string"
  ),
  PreferredMaintenanceWindow = "string",
  AutomatedSnapshotRetentionPeriod = 123,
  ManualSnapshotRetentionPeriod = 123,
  KmsKeyId = "string",
  NodeType = "string",
  EnhancedVpcRouting = TRUE|FALSE,
  AdditionalInfo = "string",
  IamRoles = list(
    "string"
  ),
  MaintenanceTrackName = "string",
  SnapshotScheduleIdentifier = "string",
  NumberOfNodes = 123
)
}
}

\keyword{internal}
