% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_db_proxy}
\alias{rds_modify_db_proxy}
\title{Changes the settings for an existing DB proxy}
\usage{
rds_modify_db_proxy(DBProxyName, NewDBProxyName, Auth, RequireTLS,
  IdleClientTimeout, DebugLogging, RoleArn, SecurityGroups)
}
\arguments{
\item{DBProxyName}{[required] The identifier for the \code{DBProxy} to modify.}

\item{NewDBProxyName}{The new identifier for the \code{DBProxy}. An identifier must begin with a
letter and must contain only ASCII letters, digits, and hyphens; it
can\'t end with a hyphen or contain two consecutive hyphens.}

\item{Auth}{The new authentication settings for the \code{DBProxy}.}

\item{RequireTLS}{Whether Transport Layer Security (TLS) encryption is required for
connections to the proxy. By enabling this setting, you can enforce
encrypted TLS connections to the proxy, even if the associated database
doesn\'t use TLS.}

\item{IdleClientTimeout}{The number of seconds that a connection to the proxy can be inactive
before the proxy disconnects it. You can set this value higher or lower
than the connection timeout limit for the associated database.}

\item{DebugLogging}{Whether the proxy includes detailed information about SQL statements in
its logs. This information helps you to debug issues involving SQL
behavior or the performance and scalability of the proxy connections.
The debug information includes the text of SQL statements that you
submit through the proxy. Thus, only enable this setting when needed for
debugging, and only when you have security measures in place to
safeguard any sensitive information that appears in the logs.}

\item{RoleArn}{The Amazon Resource Name (ARN) of the IAM role that the proxy uses to
access secrets in AWS Secrets Manager.}

\item{SecurityGroups}{The new list of security groups for the \code{DBProxy}.}
}
\description{
Changes the settings for an existing DB proxy.
}
\section{Request syntax}{
\preformatted{svc$modify_db_proxy(
  DBProxyName = "string",
  NewDBProxyName = "string",
  Auth = list(
    list(
      Description = "string",
      UserName = "string",
      AuthScheme = "SECRETS",
      SecretArn = "string",
      IAMAuth = "DISABLED"|"REQUIRED"
    )
  ),
  RequireTLS = TRUE|FALSE,
  IdleClientTimeout = 123,
  DebugLogging = TRUE|FALSE,
  RoleArn = "string",
  SecurityGroups = list(
    "string"
  )
)
}
}

\keyword{internal}
