% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_describe_db_cluster_snapshots}
\alias{docdb_describe_db_cluster_snapshots}
\title{Returns information about cluster snapshots}
\usage{
docdb_describe_db_cluster_snapshots(
  DBClusterIdentifier = NULL,
  DBClusterSnapshotIdentifier = NULL,
  SnapshotType = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL,
  IncludeShared = NULL,
  IncludePublic = NULL
)
}
\arguments{
\item{DBClusterIdentifier}{The ID of the cluster to retrieve the list of cluster snapshots for.
This parameter can't be used with the \code{DBClusterSnapshotIdentifier}
parameter. This parameter is not case sensitive.

Constraints:
\itemize{
\item If provided, must match the identifier of an existing \code{DBCluster}.
}}

\item{DBClusterSnapshotIdentifier}{A specific cluster snapshot identifier to describe. This parameter can't
be used with the \code{DBClusterIdentifier} parameter. This value is stored
as a lowercase string.

Constraints:
\itemize{
\item If provided, must match the identifier of an existing
\code{DBClusterSnapshot}.
\item If this identifier is for an automated snapshot, the \code{SnapshotType}
parameter must also be specified.
}}

\item{SnapshotType}{The type of cluster snapshots to be returned. You can specify one of the
following values:
\itemize{
\item \code{automated} - Return all cluster snapshots that Amazon DocumentDB
has automatically created for your Amazon Web Services account.
\item \code{manual} - Return all cluster snapshots that you have manually
created for your Amazon Web Services account.
\item \code{shared} - Return all manual cluster snapshots that have been shared
to your Amazon Web Services account.
\item \code{public} - Return all cluster snapshots that have been marked as
public.
}

If you don't specify a \code{SnapshotType} value, then both automated and
manual cluster snapshots are returned. You can include shared cluster
snapshots with these results by setting the \code{IncludeShared} parameter to
\code{true}. You can include public cluster snapshots with these results by
setting the\code{IncludePublic} parameter to \code{true}.

The \code{IncludeShared} and \code{IncludePublic} parameters don't apply for
\code{SnapshotType} values of \code{manual} or \code{automated}. The \code{IncludePublic}
parameter doesn't apply when \code{SnapshotType} is set to \code{shared}. The
\code{IncludeShared} parameter doesn't apply when \code{SnapshotType} is set to
\code{public}.}

\item{Filters}{This parameter is not currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
(marker) is included in the response so that the remaining results can
be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}

\item{IncludeShared}{Set to \code{true} to include shared manual cluster snapshots from other
Amazon Web Services accounts that this Amazon Web Services account has
been given permission to copy or restore, and otherwise \code{false}. The
default is \code{false}.}

\item{IncludePublic}{Set to \code{true} to include manual cluster snapshots that are public and
can be copied or restored by any Amazon Web Services account, and
otherwise \code{false}. The default is \code{false}.}
}
\description{
Returns information about cluster snapshots. This API operation supports pagination.

See \url{https://paws-r.github.io/docs/docdb/describe_db_cluster_snapshots.html} for full documentation.
}
\keyword{internal}
