% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_delete_objects_on_cancel}
\alias{lakeformation_delete_objects_on_cancel}
\title{For a specific governed table, provides a list of Amazon S3 objects that
will be written during the current transaction and that can be
automatically deleted if the transaction is canceled}
\usage{
lakeformation_delete_objects_on_cancel(
  CatalogId = NULL,
  DatabaseName,
  TableName,
  TransactionId,
  Objects
)
}
\arguments{
\item{CatalogId}{The Glue data catalog that contains the governed table. Defaults to the
current account ID.}

\item{DatabaseName}{[required] The database that contains the governed table.}

\item{TableName}{[required] The name of the governed table.}

\item{TransactionId}{[required] ID of the transaction that the writes occur in.}

\item{Objects}{[required] A list of VirtualObject structures, which indicates the Amazon S3
objects to be deleted if the transaction cancels.}
}
\description{
For a specific governed table, provides a list of Amazon S3 objects that will be written during the current transaction and that can be automatically deleted if the transaction is canceled. Without this call, no Amazon S3 objects are automatically deleted when a transaction cancels.

See \url{https://paws-r.github.io/docs/lakeformation/delete_objects_on_cancel.html} for full documentation.
}
\keyword{internal}
