% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memorydb_operations.R
\name{memorydb_describe_engine_versions}
\alias{memorydb_describe_engine_versions}
\title{Returns a list of the available Redis engine versions}
\usage{
memorydb_describe_engine_versions(
  EngineVersion = NULL,
  ParameterGroupFamily = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DefaultOnly = NULL
)
}
\arguments{
\item{EngineVersion}{The Redis engine version}

\item{ParameterGroupFamily}{The name of a specific parameter group family to return details for.}

\item{MaxResults}{The maximum number of records to include in the response. If more
records exist than the specified MaxResults value, a token is included
in the response so that the remaining results can be retrieved.}

\item{NextToken}{An optional argument to pass in case the total number of records exceeds
the value of MaxResults. If nextToken is returned, there are more
results available. The value of nextToken is a unique pagination token
for each page. Make the call again using the returned token to retrieve
the next page. Keep all other arguments unchanged.}

\item{DefaultOnly}{If true, specifies that only the default version of the specified engine
or engine and major version combination is to be returned.}
}
\description{
Returns a list of the available Redis engine versions.

See \url{https://paws-r.github.io/docs/memorydb/describe_engine_versions.html} for full documentation.
}
\keyword{internal}
