% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_failover_global_cluster}
\alias{neptune_failover_global_cluster}
\title{Initiates the failover process for a Neptune global database}
\usage{
neptune_failover_global_cluster(
  GlobalClusterIdentifier,
  TargetDbClusterIdentifier
)
}
\arguments{
\item{GlobalClusterIdentifier}{[required] Identifier of the Neptune global database that should be failed over.
The identifier is the unique key assigned by the user when the Neptune
global database was created. In other words, it's the name of the global
database that you want to fail over.

Constraints: Must match the identifier of an existing Neptune global
database.}

\item{TargetDbClusterIdentifier}{[required] The Amazon Resource Name (ARN) of the secondary Neptune DB cluster that
you want to promote to primary for the global database.}
}
\description{
Initiates the failover process for a Neptune global database.

See \url{https://paws-r.github.io/docs/neptune/failover_global_cluster.html} for full documentation.
}
\keyword{internal}
