% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_cluster_backtracks}
\alias{rds_describe_db_cluster_backtracks}
\title{Returns information about backtracks for a DB cluster}
\usage{
rds_describe_db_cluster_backtracks(
  DBClusterIdentifier,
  BacktrackIdentifier = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier of the DB cluster to be described. This
parameter is stored as a lowercase string.

Constraints:
\itemize{
\item Must contain from 1 to 63 alphanumeric characters or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster1}}

\item{BacktrackIdentifier}{If specified, this value is the backtrack identifier of the backtrack to
be described.

Constraints:
\itemize{
\item Must contain a valid universally unique identifier (UUID). For more
information about UUIDs, see \href{https://www.ietf.org/rfc/rfc4122.txt}{A Universally Unique Identifier (UUID) URN Namespace}.
}

Example: \verb{123e4567-e89b-12d3-a456-426655440000}}

\item{Filters}{A filter that specifies one or more DB clusters to describe. Supported
filters include the following:
\itemize{
\item \code{db-cluster-backtrack-id} - Accepts backtrack identifiers. The
results list includes information about only the backtracks
identified by these identifiers.
\item \code{db-cluster-backtrack-status} - Accepts any of the following
backtrack status values:
\itemize{
\item \code{applying}
\item \code{completed}
\item \code{failed}
\item \code{pending}
}

The results list includes information about only the backtracks
identified by these values.
}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_db_cluster_backtracks]{describe_db_cluster_backtracks}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Returns information about backtracks for a DB cluster.

See \url{https://paws-r.github.io/docs/rds/describe_db_cluster_backtracks.html} for full documentation.
}
\keyword{internal}
