% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_source_regions}
\alias{rds_describe_source_regions}
\title{Returns a list of the source Amazon Web Services Regions where the
current Amazon Web Services Region can create a read replica, copy a DB
snapshot from, or replicate automated backups from}
\usage{
rds_describe_source_regions(
  RegionName = NULL,
  MaxRecords = NULL,
  Marker = NULL,
  Filters = NULL
)
}
\arguments{
\item{RegionName}{The source Amazon Web Services Region name. For example, \code{us-east-1}.

Constraints:
\itemize{
\item Must specify a valid Amazon Web Services Region name.
}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_source_regions]{describe_source_regions}} request. If
this parameter is specified, the response includes only records beyond
the marker, up to the value specified by \code{MaxRecords}.}

\item{Filters}{This parameter isn't currently supported.}
}
\description{
Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create a read replica, copy a DB snapshot from, or replicate automated backups from. This API action supports pagination.

See \url{https://paws-r.github.io/docs/rds/describe_source_regions.html} for full documentation.
}
\keyword{internal}
