% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_scheduled_action}
\alias{redshift_modify_scheduled_action}
\title{Modifies a scheduled action}
\usage{
redshift_modify_scheduled_action(
  ScheduledActionName,
  TargetAction = NULL,
  Schedule = NULL,
  IamRole = NULL,
  ScheduledActionDescription = NULL,
  StartTime = NULL,
  EndTime = NULL,
  Enable = NULL
)
}
\arguments{
\item{ScheduledActionName}{[required] The name of the scheduled action to modify.}

\item{TargetAction}{A modified JSON format of the scheduled action. For more information
about this parameter, see ScheduledAction.}

\item{Schedule}{A modified schedule in either \code{at( )} or \code{cron( )} format. For more
information about this parameter, see ScheduledAction.}

\item{IamRole}{A different IAM role to assume to run the target action. For more
information about this parameter, see ScheduledAction.}

\item{ScheduledActionDescription}{A modified description of the scheduled action.}

\item{StartTime}{A modified start time of the scheduled action. For more information
about this parameter, see ScheduledAction.}

\item{EndTime}{A modified end time of the scheduled action. For more information about
this parameter, see ScheduledAction.}

\item{Enable}{A modified enable flag of the scheduled action. If true, the scheduled
action is active. If false, the scheduled action is disabled.}
}
\description{
Modifies a scheduled action.

See \url{https://paws-r.github.io/docs/redshift/modify_scheduled_action.html} for full documentation.
}
\keyword{internal}
