% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_cluster_from_s3}
\alias{rds_restore_db_cluster_from_s3}
\title{Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon
S3 bucket}
\usage{
rds_restore_db_cluster_from_s3(
  AvailabilityZones = NULL,
  BackupRetentionPeriod = NULL,
  CharacterSetName = NULL,
  DatabaseName = NULL,
  DBClusterIdentifier,
  DBClusterParameterGroupName = NULL,
  VpcSecurityGroupIds = NULL,
  DBSubnetGroupName = NULL,
  Engine,
  EngineVersion = NULL,
  Port = NULL,
  MasterUsername,
  MasterUserPassword = NULL,
  OptionGroupName = NULL,
  PreferredBackupWindow = NULL,
  PreferredMaintenanceWindow = NULL,
  Tags = NULL,
  StorageEncrypted = NULL,
  KmsKeyId = NULL,
  EnableIAMDatabaseAuthentication = NULL,
  SourceEngine,
  SourceEngineVersion,
  S3BucketName,
  S3Prefix = NULL,
  S3IngestionRoleArn,
  BacktrackWindow = NULL,
  EnableCloudwatchLogsExports = NULL,
  DeletionProtection = NULL,
  CopyTagsToSnapshot = NULL,
  Domain = NULL,
  DomainIAMRoleName = NULL,
  ServerlessV2ScalingConfiguration = NULL,
  NetworkType = NULL,
  ManageMasterUserPassword = NULL,
  MasterUserSecretKmsKeyId = NULL,
  StorageType = NULL
)
}
\arguments{
\item{AvailabilityZones}{A list of Availability Zones (AZs) where instances in the restored DB
cluster can be created.}

\item{BackupRetentionPeriod}{The number of days for which automated backups of the restored DB
cluster are retained. You must specify a minimum value of 1.

Default: 1

Constraints:
\itemize{
\item Must be a value from 1 to 35
}}

\item{CharacterSetName}{A value that indicates that the restored DB cluster should be associated
with the specified CharacterSet.}

\item{DatabaseName}{The database name for the restored DB cluster.}

\item{DBClusterIdentifier}{[required] The name of the DB cluster to create from the source data in the Amazon
S3 bucket. This parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster1}}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to associate with the
restored DB cluster. If this argument is omitted, the default parameter
group for the engine version is used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing
DBClusterParameterGroup.
}}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with the restored DB
cluster.}

\item{DBSubnetGroupName}{A DB subnet group to associate with the restored DB cluster.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mydbsubnetgroup}}

\item{Engine}{[required] The name of the database engine to be used for this DB cluster.

Valid Values: \code{aurora-mysql} (for Aurora MySQL)}

\item{EngineVersion}{The version number of the database engine to use.

To list all of the available engine versions for \code{aurora-mysql} (Aurora
MySQL), use the following command:

\verb{aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"}

\strong{Aurora MySQL}

Examples: \verb{5.7.mysql_aurora.2.07.1}, \verb{8.0.mysql_aurora.3.02.0}}

\item{Port}{The port number on which the instances in the restored DB cluster accept
connections.

Default: \code{3306}}

\item{MasterUsername}{[required] The name of the master user for the restored DB cluster.

Constraints:
\itemize{
\item Must be 1 to 16 letters or numbers.
\item First character must be a letter.
\item Can't be a reserved word for the chosen database engine.
}}

\item{MasterUserPassword}{The password for the master database user. This password can contain any
printable ASCII character except "/", """, or "@".

Constraints:
\itemize{
\item Must contain from 8 to 41 characters.
\item Can't be specified if \code{ManageMasterUserPassword} is turned on.
}}

\item{OptionGroupName}{A value that indicates that the restored DB cluster should be associated
with the specified option group.

Permanent options can't be removed from an option group. An option group
can't be removed from a DB cluster once it is associated with a DB
cluster.}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled using the \code{BackupRetentionPeriod}
parameter.

The default is a 30-minute window selected at random from an 8-hour
block of time for each Amazon Web Services Region. To view the time
blocks available, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow}{Backup window}
in the \emph{Amazon Aurora User Guide}.

Constraints:
\itemize{
\item Must be in the format \code{hh24:mi-hh24:mi}.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}

\item{PreferredMaintenanceWindow}{The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

The default is a 30-minute window selected at random from an 8-hour
block of time for each Amazon Web Services Region, occurring on a random
day of the week. To see the time blocks available, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora}{Adjusting the Preferred Maintenance Window}
in the \emph{Amazon Aurora User Guide}.

Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

Constraints: Minimum 30-minute window.}

\item{Tags}{}

\item{StorageEncrypted}{A value that indicates whether the restored DB cluster is encrypted.}

\item{KmsKeyId}{The Amazon Web Services KMS key identifier for an encrypted DB cluster.

The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
ARN, or alias name for the KMS key. To use a KMS key in a different
Amazon Web Services account, specify the key ARN or alias ARN.

If the StorageEncrypted parameter is enabled, and you do not specify a
value for the \code{KmsKeyId} parameter, then Amazon RDS will use your
default KMS key. There is a default KMS key for your Amazon Web Services
account. Your Amazon Web Services account has a different default KMS
key for each Amazon Web Services Region.}

\item{EnableIAMDatabaseAuthentication}{A value that indicates whether to enable mapping of Amazon Web Services
Identity and Access Management (IAM) accounts to database accounts. By
default, mapping isn't enabled.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication}
in the \emph{Amazon Aurora User Guide}.}

\item{SourceEngine}{[required] The identifier for the database engine that was backed up to create the
files stored in the Amazon S3 bucket.

Valid values: \code{mysql}}

\item{SourceEngineVersion}{[required] The version of the database that the backup files were created from.

MySQL versions 5.5, 5.6, and 5.7 are supported.

Example: \verb{5.6.40}, \verb{5.7.28}}

\item{S3BucketName}{[required] The name of the Amazon S3 bucket that contains the data used to create
the Amazon Aurora DB cluster.}

\item{S3Prefix}{The prefix for all of the file names that contain the data used to
create the Amazon Aurora DB cluster. If you do not specify a
\strong{SourceS3Prefix} value, then the Amazon Aurora DB cluster is created
by using all of the files in the Amazon S3 bucket.}

\item{S3IngestionRoleArn}{[required] The Amazon Resource Name (ARN) of the Amazon Web Services Identity and
Access Management (IAM) role that authorizes Amazon RDS to access the
Amazon S3 bucket on your behalf.}

\item{BacktrackWindow}{The target backtrack window, in seconds. To disable backtracking, set
this value to 0.

Currently, Backtrack is only supported for Aurora MySQL DB clusters.

Default: 0

Constraints:
\itemize{
\item If specified, this value must be set to a number from 0 to 259,200
(72 hours).
}}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB cluster is to export to CloudWatch
Logs. The values in the list depend on the DB engine being used.

\strong{Aurora MySQL}

Possible values are \code{audit}, \code{error}, \code{general}, and \code{slowquery}.

For more information about exporting CloudWatch Logs for Amazon Aurora,
see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon Aurora User Guide}.}

\item{DeletionProtection}{A value that indicates whether the DB cluster has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection isn't enabled.}

\item{CopyTagsToSnapshot}{A value that indicates whether to copy all tags from the restored DB
cluster to snapshots of the restored DB cluster. The default is not to
copy them.}

\item{Domain}{Specify the Active Directory directory ID to restore the DB cluster in.
The domain must be created prior to this operation.

For Amazon Aurora DB clusters, Amazon RDS can use Kerberos
Authentication to authenticate users that connect to the DB cluster. For
more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/database-authentication.html}{Kerberos Authentication}
in the \emph{Amazon Aurora User Guide}.}

\item{DomainIAMRoleName}{Specify the name of the IAM role to be used when making API calls to the
Directory Service.}

\item{ServerlessV2ScalingConfiguration}{}

\item{NetworkType}{The network type of the DB cluster.

Valid values:
\itemize{
\item \code{IPV4}
\item \code{DUAL}
}

The network type is determined by the \code{DBSubnetGroup} specified for the
DB cluster. A \code{DBSubnetGroup} can support only the IPv4 protocol or the
IPv4 and the IPv6 protocols (\code{DUAL}).

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html}{Working with a DB instance in a VPC}
in the \emph{Amazon Aurora User Guide.}}

\item{ManageMasterUserPassword}{A value that indicates whether to manage the master user password with
Amazon Web Services Secrets Manager.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html}{Password management with Amazon Web Services Secrets Manager}
in the \emph{Amazon RDS User Guide} and \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html}{Password management with Amazon Web Services Secrets Manager}
in the \emph{Amazon Aurora User Guide.}

Constraints:
\itemize{
\item Can't manage the master user password with Amazon Web Services
Secrets Manager if \code{MasterUserPassword} is specified.
}}

\item{MasterUserSecretKmsKeyId}{The Amazon Web Services KMS key identifier to encrypt a secret that is
automatically generated and managed in Amazon Web Services Secrets
Manager.

This setting is valid only if the master user password is managed by RDS
in Amazon Web Services Secrets Manager for the DB cluster.

The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
ARN, or alias name for the KMS key. To use a KMS key in a different
Amazon Web Services account, specify the key ARN or alias ARN.

If you don't specify \code{MasterUserSecretKmsKeyId}, then the
\code{aws/secretsmanager} KMS key is used to encrypt the secret. If the
secret is in a different Amazon Web Services account, then you can't use
the \code{aws/secretsmanager} KMS key to encrypt the secret, and you must use
a customer managed KMS key.

There is a default KMS key for your Amazon Web Services account. Your
Amazon Web Services account has a different default KMS key for each
Amazon Web Services Region.}

\item{StorageType}{Specifies the storage type to be associated with the DB cluster.

Valid values: \code{aurora}, \code{aurora-iopt1}

Default: \code{aurora}

Valid for: Aurora DB clusters only}
}
\description{
Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon S3 bucket. Amazon RDS must be authorized to access the Amazon S3 bucket and the data must be created using the Percona XtraBackup utility as described in \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3}{Migrating Data from MySQL by Using an Amazon S3 Bucket} in the \emph{Amazon Aurora User Guide}.

See \url{https://www.paws-r-sdk.com/docs/rds_restore_db_cluster_from_s3/} for full documentation.
}
\keyword{internal}
