% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_create_cluster_snapshot}
\alias{redshift_create_cluster_snapshot}
\title{Creates a manual snapshot of the specified cluster}
\usage{
redshift_create_cluster_snapshot(
  SnapshotIdentifier,
  ClusterIdentifier,
  ManualSnapshotRetentionPeriod = NULL,
  Tags = NULL
)
}
\arguments{
\item{SnapshotIdentifier}{[required] A unique identifier for the snapshot that you are requesting. This
identifier must be unique for all snapshots within the Amazon Web
Services account.

Constraints:
\itemize{
\item Cannot be null, empty, or blank
\item Must contain from 1 to 255 alphanumeric characters or hyphens
\item First character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-snapshot-id}}

\item{ClusterIdentifier}{[required] The cluster identifier for which you want a snapshot.}

\item{ManualSnapshotRetentionPeriod}{The number of days that a manual snapshot is retained. If the value is
-1, the manual snapshot is retained indefinitely.

The value must be either -1 or an integer between 1 and 3,653.

The default value is -1.}

\item{Tags}{A list of tag instances.}
}
\description{
Creates a manual snapshot of the specified cluster. The cluster must be in the \code{available} state.

See \url{https://www.paws-r-sdk.com/docs/redshift_create_cluster_snapshot/} for full documentation.
}
\keyword{internal}
