% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftserverless_operations.R
\name{redshiftserverless_restore_table_from_snapshot}
\alias{redshiftserverless_restore_table_from_snapshot}
\title{Restores a table from a snapshot to your Amazon Redshift Serverless
instance}
\usage{
redshiftserverless_restore_table_from_snapshot(
  activateCaseSensitiveIdentifier = NULL,
  namespaceName,
  newTableName,
  snapshotName,
  sourceDatabaseName,
  sourceSchemaName = NULL,
  sourceTableName,
  targetDatabaseName = NULL,
  targetSchemaName = NULL,
  workgroupName
)
}
\arguments{
\item{activateCaseSensitiveIdentifier}{Indicates whether name identifiers for database, schema, and table are
case sensitive. If true, the names are case sensitive. If false, the
names are not case sensitive. The default is false.}

\item{namespaceName}{[required] The namespace of the snapshot to restore from.}

\item{newTableName}{[required] The name of the table to create from the restore operation.}

\item{snapshotName}{[required] The name of the snapshot to restore the table from.}

\item{sourceDatabaseName}{[required] The name of the source database that contains the table being restored.}

\item{sourceSchemaName}{The name of the source schema that contains the table being restored.}

\item{sourceTableName}{[required] The name of the source table being restored.}

\item{targetDatabaseName}{The name of the database to restore the table to.}

\item{targetSchemaName}{The name of the schema to restore the table to.}

\item{workgroupName}{[required] The workgroup to restore the table to.}
}
\description{
Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use this operation to restore tables with \href{https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved}{interleaved sort keys}.

See \url{https://www.paws-r-sdk.com/docs/redshiftserverless_restore_table_from_snapshot/} for full documentation.
}
\keyword{internal}
