# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include rdsdataservice_service.R
NULL

#' Runs a batch SQL statement over an array of data
#'
#' @description
#' Runs a batch SQL statement over an array of data.
#'
#' See [https://www.paws-r-sdk.com/docs/rdsdataservice_batch_execute_statement/](https://www.paws-r-sdk.com/docs/rdsdataservice_batch_execute_statement/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
#' @param secretArn &#91;required&#93; The ARN of the secret that enables access to the DB cluster. Enter the
#' database user name and password for the credentials in the secret.
#' 
#' For information about creating the secret, see [Create a database
#' secret](https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html).
#' @param sql &#91;required&#93; The SQL statement to run. Don't include a semicolon (;) at the end of
#' the SQL statement.
#' @param database The name of the database.
#' @param schema The name of the database schema.
#' 
#' Currently, the `schema` parameter isn't supported.
#' @param parameterSets The parameter set for the batch operation.
#' 
#' The SQL statement is executed as many times as the number of parameter
#' sets provided. To execute a SQL statement with no parameters, use one of
#' the following options:
#' 
#' -   Specify one or more empty parameter sets.
#' 
#' -   Use the [`execute_statement`][rdsdataservice_execute_statement]
#'     operation instead of the
#'     [`batch_execute_statement`][rdsdataservice_batch_execute_statement]
#'     operation.
#' 
#' Array parameters are not supported.
#' @param transactionId The identifier of a transaction that was started by using the
#' [`begin_transaction`][rdsdataservice_begin_transaction] operation.
#' Specify the transaction ID of the transaction that you want to include
#' the SQL statement in.
#' 
#' If the SQL statement is not part of a transaction, don't set this
#' parameter.
#'
#' @keywords internal
#'
#' @rdname rdsdataservice_batch_execute_statement
rdsdataservice_batch_execute_statement <- function(resourceArn, secretArn, sql, database = NULL, schema = NULL, parameterSets = NULL, transactionId = NULL) {
  op <- new_operation(
    name = "BatchExecuteStatement",
    http_method = "POST",
    http_path = "/BatchExecute",
    host_prefix = "",
    paginator = list()
  )
  input <- .rdsdataservice$batch_execute_statement_input(resourceArn = resourceArn, secretArn = secretArn, sql = sql, database = database, schema = schema, parameterSets = parameterSets, transactionId = transactionId)
  output <- .rdsdataservice$batch_execute_statement_output()
  config <- get_config()
  svc <- .rdsdataservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rdsdataservice$operations$batch_execute_statement <- rdsdataservice_batch_execute_statement

#' Starts a SQL transaction
#'
#' @description
#' Starts a SQL transaction.
#'
#' See [https://www.paws-r-sdk.com/docs/rdsdataservice_begin_transaction/](https://www.paws-r-sdk.com/docs/rdsdataservice_begin_transaction/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
#' @param secretArn &#91;required&#93; The name or ARN of the secret that enables access to the DB cluster.
#' @param database The name of the database.
#' @param schema The name of the database schema.
#'
#' @keywords internal
#'
#' @rdname rdsdataservice_begin_transaction
rdsdataservice_begin_transaction <- function(resourceArn, secretArn, database = NULL, schema = NULL) {
  op <- new_operation(
    name = "BeginTransaction",
    http_method = "POST",
    http_path = "/BeginTransaction",
    host_prefix = "",
    paginator = list()
  )
  input <- .rdsdataservice$begin_transaction_input(resourceArn = resourceArn, secretArn = secretArn, database = database, schema = schema)
  output <- .rdsdataservice$begin_transaction_output()
  config <- get_config()
  svc <- .rdsdataservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rdsdataservice$operations$begin_transaction <- rdsdataservice_begin_transaction

#' Ends a SQL transaction started with the BeginTransaction operation and
#' commits the changes
#'
#' @description
#' Ends a SQL transaction started with the [`begin_transaction`][rdsdataservice_begin_transaction] operation and commits the changes.
#'
#' See [https://www.paws-r-sdk.com/docs/rdsdataservice_commit_transaction/](https://www.paws-r-sdk.com/docs/rdsdataservice_commit_transaction/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
#' @param secretArn &#91;required&#93; The name or ARN of the secret that enables access to the DB cluster.
#' @param transactionId &#91;required&#93; The identifier of the transaction to end and commit.
#'
#' @keywords internal
#'
#' @rdname rdsdataservice_commit_transaction
rdsdataservice_commit_transaction <- function(resourceArn, secretArn, transactionId) {
  op <- new_operation(
    name = "CommitTransaction",
    http_method = "POST",
    http_path = "/CommitTransaction",
    host_prefix = "",
    paginator = list()
  )
  input <- .rdsdataservice$commit_transaction_input(resourceArn = resourceArn, secretArn = secretArn, transactionId = transactionId)
  output <- .rdsdataservice$commit_transaction_output()
  config <- get_config()
  svc <- .rdsdataservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rdsdataservice$operations$commit_transaction <- rdsdataservice_commit_transaction

#' Runs one or more SQL statements
#'
#' @description
#' Runs one or more SQL statements.
#'
#' See [https://www.paws-r-sdk.com/docs/rdsdataservice_execute_sql/](https://www.paws-r-sdk.com/docs/rdsdataservice_execute_sql/) for full documentation.
#'
#' @param dbClusterOrInstanceArn &#91;required&#93; The ARN of the Aurora Serverless DB cluster.
#' @param awsSecretStoreArn &#91;required&#93; The Amazon Resource Name (ARN) of the secret that enables access to the
#' DB cluster. Enter the database user name and password for the
#' credentials in the secret.
#' 
#' For information about creating the secret, see [Create a database
#' secret](https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html).
#' @param sqlStatements &#91;required&#93; One or more SQL statements to run on the DB cluster.
#' 
#' You can separate SQL statements from each other with a semicolon (;).
#' Any valid SQL statement is permitted, including data definition, data
#' manipulation, and commit statements.
#' @param database The name of the database.
#' @param schema The name of the database schema.
#'
#' @keywords internal
#'
#' @rdname rdsdataservice_execute_sql
rdsdataservice_execute_sql <- function(dbClusterOrInstanceArn, awsSecretStoreArn, sqlStatements, database = NULL, schema = NULL) {
  op <- new_operation(
    name = "ExecuteSql",
    http_method = "POST",
    http_path = "/ExecuteSql",
    host_prefix = "",
    paginator = list()
  )
  input <- .rdsdataservice$execute_sql_input(dbClusterOrInstanceArn = dbClusterOrInstanceArn, awsSecretStoreArn = awsSecretStoreArn, sqlStatements = sqlStatements, database = database, schema = schema)
  output <- .rdsdataservice$execute_sql_output()
  config <- get_config()
  svc <- .rdsdataservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rdsdataservice$operations$execute_sql <- rdsdataservice_execute_sql

#' Runs a SQL statement against a database
#'
#' @description
#' Runs a SQL statement against a database.
#'
#' See [https://www.paws-r-sdk.com/docs/rdsdataservice_execute_statement/](https://www.paws-r-sdk.com/docs/rdsdataservice_execute_statement/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
#' @param secretArn &#91;required&#93; The ARN of the secret that enables access to the DB cluster. Enter the
#' database user name and password for the credentials in the secret.
#' 
#' For information about creating the secret, see [Create a database
#' secret](https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html).
#' @param sql &#91;required&#93; The SQL statement to run.
#' @param database The name of the database.
#' @param schema The name of the database schema.
#' 
#' Currently, the `schema` parameter isn't supported.
#' @param parameters The parameters for the SQL statement.
#' 
#' Array parameters are not supported.
#' @param transactionId The identifier of a transaction that was started by using the
#' [`begin_transaction`][rdsdataservice_begin_transaction] operation.
#' Specify the transaction ID of the transaction that you want to include
#' the SQL statement in.
#' 
#' If the SQL statement is not part of a transaction, don't set this
#' parameter.
#' @param includeResultMetadata A value that indicates whether to include metadata in the results.
#' @param continueAfterTimeout A value that indicates whether to continue running the statement after
#' the call times out. By default, the statement stops running when the
#' call times out.
#' 
#' For DDL statements, we recommend continuing to run the statement after
#' the call times out. When a DDL statement terminates before it is
#' finished running, it can result in errors and possibly corrupted data
#' structures.
#' @param resultSetOptions Options that control how the result set is returned.
#' @param formatRecordsAs A value that indicates whether to format the result set as a single JSON
#' string. This parameter only applies to `SELECT` statements and is
#' ignored for other types of statements. Allowed values are `NONE` and
#' `JSON`. The default value is `NONE`. The result is returned in the
#' `formattedRecords` field.
#' 
#' For usage information about the JSON format for result sets, see [Using
#' the Data
#' API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html)
#' in the *Amazon Aurora User Guide*.
#'
#' @keywords internal
#'
#' @rdname rdsdataservice_execute_statement
rdsdataservice_execute_statement <- function(resourceArn, secretArn, sql, database = NULL, schema = NULL, parameters = NULL, transactionId = NULL, includeResultMetadata = NULL, continueAfterTimeout = NULL, resultSetOptions = NULL, formatRecordsAs = NULL) {
  op <- new_operation(
    name = "ExecuteStatement",
    http_method = "POST",
    http_path = "/Execute",
    host_prefix = "",
    paginator = list()
  )
  input <- .rdsdataservice$execute_statement_input(resourceArn = resourceArn, secretArn = secretArn, sql = sql, database = database, schema = schema, parameters = parameters, transactionId = transactionId, includeResultMetadata = includeResultMetadata, continueAfterTimeout = continueAfterTimeout, resultSetOptions = resultSetOptions, formatRecordsAs = formatRecordsAs)
  output <- .rdsdataservice$execute_statement_output()
  config <- get_config()
  svc <- .rdsdataservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rdsdataservice$operations$execute_statement <- rdsdataservice_execute_statement

#' Performs a rollback of a transaction
#'
#' @description
#' Performs a rollback of a transaction. Rolling back a transaction cancels its changes.
#'
#' See [https://www.paws-r-sdk.com/docs/rdsdataservice_rollback_transaction/](https://www.paws-r-sdk.com/docs/rdsdataservice_rollback_transaction/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
#' @param secretArn &#91;required&#93; The name or ARN of the secret that enables access to the DB cluster.
#' @param transactionId &#91;required&#93; The identifier of the transaction to roll back.
#'
#' @keywords internal
#'
#' @rdname rdsdataservice_rollback_transaction
rdsdataservice_rollback_transaction <- function(resourceArn, secretArn, transactionId) {
  op <- new_operation(
    name = "RollbackTransaction",
    http_method = "POST",
    http_path = "/RollbackTransaction",
    host_prefix = "",
    paginator = list()
  )
  input <- .rdsdataservice$rollback_transaction_input(resourceArn = resourceArn, secretArn = secretArn, transactionId = transactionId)
  output <- .rdsdataservice$rollback_transaction_output()
  config <- get_config()
  svc <- .rdsdataservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rdsdataservice$operations$rollback_transaction <- rdsdataservice_rollback_transaction
