% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdbelastic_operations.R
\name{docdbelastic_apply_pending_maintenance_action}
\alias{docdbelastic_apply_pending_maintenance_action}
\title{The type of pending maintenance action to be applied to the resource}
\usage{
docdbelastic_apply_pending_maintenance_action(
  applyAction,
  applyOn = NULL,
  optInType,
  resourceArn
)
}
\arguments{
\item{applyAction}{[required] The pending maintenance action to apply to the resource.

Valid actions are:
\itemize{
\item \code{ENGINE_UPDATE }
\item \code{ENGINE_UPGRADE}
\item \code{SECURITY_UPDATE}
\item \code{OS_UPDATE}
\item \code{MASTER_USER_PASSWORD_UPDATE}
}}

\item{applyOn}{A specific date to apply the pending maintenance action. Required if
opt-in-type is \code{APPLY_ON}. Format: \verb{yyyy/MM/dd HH:mm-yyyy/MM/dd HH:mm}}

\item{optInType}{[required] A value that specifies the type of opt-in request, or undoes an opt-in
request. An opt-in request of type \code{IMMEDIATE} can't be undone.}

\item{resourceArn}{[required] The Amazon DocumentDB Amazon Resource Name (ARN) of the resource to
which the pending maintenance action applies.}
}
\description{
The type of pending maintenance action to be applied to the resource.

See \url{https://www.paws-r-sdk.com/docs/docdbelastic_apply_pending_maintenance_action/} for full documentation.
}
\keyword{internal}
