% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyspaces_operations.R
\name{keyspaces_create_type}
\alias{keyspaces_create_type}
\title{The CreateType operation creates a new user-defined type in the
specified keyspace}
\usage{
keyspaces_create_type(keyspaceName, typeName, fieldDefinitions)
}
\arguments{
\item{keyspaceName}{[required] The name of the keyspace.}

\item{typeName}{[required] The name of the user-defined type.

UDT names must contain 48 characters or less, must begin with an
alphabetic character, and can only contain alpha-numeric characters and
underscores. Amazon Keyspaces converts upper case characters
automatically into lower case characters.

Alternatively, you can declare a UDT name in double quotes. When
declaring a UDT name inside double quotes, Amazon Keyspaces preserves
upper casing and allows special characters.

You can also use double quotes as part of the name when you create the
UDT, but you must escape each double quote character with an additional
double quote character.}

\item{fieldDefinitions}{[required] The field definitions, consisting of names and types, that define this
type.}
}
\description{
The \code{\link[=keyspaces_create_type]{create_type}} operation creates a new user-defined type in the specified keyspace.

See \url{https://www.paws-r-sdk.com/docs/keyspaces_create_type/} for full documentation.
}
\keyword{internal}
