# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloud9_service.R
NULL

#' Creates an AWS Cloud9 development environment, launches an Amazon
#' Elastic Compute Cloud (Amazon EC2) instance, and then connects from the
#' instance to the environment
#'
#' @description
#' Creates an AWS Cloud9 development environment, launches an Amazon
#' Elastic Compute Cloud (Amazon EC2) instance, and then connects from the
#' instance to the environment.
#'
#' @usage
#' cloud9_create_environment_ec2(name, description, clientRequestToken,
#'   instanceType, subnetId, automaticStopTimeMinutes, ownerArn, tags,
#'   connectionType)
#'
#' @param name &#91;required&#93; The name of the environment to create.
#' 
#' This name is visible to other AWS IAM users in the same AWS account.
#' @param description The description of the environment to create.
#' @param clientRequestToken A unique, case-sensitive string that helps AWS Cloud9 to ensure this
#' operation completes no more than one time.
#' 
#' For more information, see [Client
#' Tokens](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
#' in the *Amazon EC2 API Reference*.
#' @param instanceType &#91;required&#93; The type of instance to connect to the environment (for example,
#' `t2.micro`).
#' @param subnetId The ID of the subnet in Amazon VPC that AWS Cloud9 will use to
#' communicate with the Amazon EC2 instance.
#' @param automaticStopTimeMinutes The number of minutes until the running instance is shut down after the
#' environment has last been used.
#' @param ownerArn The Amazon Resource Name (ARN) of the environment owner. This ARN can be
#' the ARN of any AWS IAM principal. If this value is not specified, the
#' ARN defaults to this environment's creator.
#' @param tags An array of key-value pairs that will be associated with the new AWS
#' Cloud9 development environment.
#' @param connectionType The connection type used for connecting to an Amazon EC2 environment.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   environmentId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_environment_ec2(
#'   name = "string",
#'   description = "string",
#'   clientRequestToken = "string",
#'   instanceType = "string",
#'   subnetId = "string",
#'   automaticStopTimeMinutes = 123,
#'   ownerArn = "string",
#'   tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   connectionType = "CONNECT_SSH"|"CONNECT_SSM"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # 
#' svc$create_environment_ec2(
#'   name = "my-demo-environment",
#'   automaticStopTimeMinutes = 60L,
#'   description = "This is my demonstration environment.",
#'   instanceType = "t2.micro",
#'   ownerArn = "arn:aws:iam::123456789012:user/MyDemoUser",
#'   subnetId = "subnet-1fab8aEX"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname cloud9_create_environment_ec2
cloud9_create_environment_ec2 <- function(name, description = NULL, clientRequestToken = NULL, instanceType, subnetId = NULL, automaticStopTimeMinutes = NULL, ownerArn = NULL, tags = NULL, connectionType = NULL) {
  op <- new_operation(
    name = "CreateEnvironmentEC2",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$create_environment_ec2_input(name = name, description = description, clientRequestToken = clientRequestToken, instanceType = instanceType, subnetId = subnetId, automaticStopTimeMinutes = automaticStopTimeMinutes, ownerArn = ownerArn, tags = tags, connectionType = connectionType)
  output <- .cloud9$create_environment_ec2_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$create_environment_ec2 <- cloud9_create_environment_ec2

#' Adds an environment member to an AWS Cloud9 development environment
#'
#' @description
#' Adds an environment member to an AWS Cloud9 development environment.
#'
#' @usage
#' cloud9_create_environment_membership(environmentId, userArn,
#'   permissions)
#'
#' @param environmentId &#91;required&#93; The ID of the environment that contains the environment member you want
#' to add.
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) of the environment member you want to
#' add.
#' @param permissions &#91;required&#93; The type of environment member permissions you want to associate with
#' this environment member. Available values include:
#' 
#' -   `read-only`: Has read-only access to the environment.
#' 
#' -   `read-write`: Has read-write access to the environment.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   membership = list(
#'     permissions = "owner"|"read-write"|"read-only",
#'     userId = "string",
#'     userArn = "string",
#'     environmentId = "string",
#'     lastAccess = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_environment_membership(
#'   environmentId = "string",
#'   userArn = "string",
#'   permissions = "read-write"|"read-only"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # 
#' svc$create_environment_membership(
#'   environmentId = "8d9967e2f0624182b74e7690ad69ebEX",
#'   permissions = "read-write",
#'   userArn = "arn:aws:iam::123456789012:user/AnotherDemoUser"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname cloud9_create_environment_membership
cloud9_create_environment_membership <- function(environmentId, userArn, permissions) {
  op <- new_operation(
    name = "CreateEnvironmentMembership",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$create_environment_membership_input(environmentId = environmentId, userArn = userArn, permissions = permissions)
  output <- .cloud9$create_environment_membership_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$create_environment_membership <- cloud9_create_environment_membership

#' Deletes an AWS Cloud9 development environment
#'
#' @description
#' Deletes an AWS Cloud9 development environment. If an Amazon EC2 instance
#' is connected to the environment, also terminates the instance.
#'
#' @usage
#' cloud9_delete_environment(environmentId)
#'
#' @param environmentId &#91;required&#93; The ID of the environment to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_environment(
#'   environmentId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # 
#' svc$delete_environment(
#'   environmentId = "8d9967e2f0624182b74e7690ad69ebEX"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname cloud9_delete_environment
cloud9_delete_environment <- function(environmentId) {
  op <- new_operation(
    name = "DeleteEnvironment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$delete_environment_input(environmentId = environmentId)
  output <- .cloud9$delete_environment_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$delete_environment <- cloud9_delete_environment

#' Deletes an environment member from an AWS Cloud9 development environment
#'
#' @description
#' Deletes an environment member from an AWS Cloud9 development
#' environment.
#'
#' @usage
#' cloud9_delete_environment_membership(environmentId, userArn)
#'
#' @param environmentId &#91;required&#93; The ID of the environment to delete the environment member from.
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) of the environment member to delete from
#' the environment.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_environment_membership(
#'   environmentId = "string",
#'   userArn = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # 
#' svc$delete_environment_membership(
#'   environmentId = "8d9967e2f0624182b74e7690ad69ebEX",
#'   userArn = "arn:aws:iam::123456789012:user/AnotherDemoUser"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname cloud9_delete_environment_membership
cloud9_delete_environment_membership <- function(environmentId, userArn) {
  op <- new_operation(
    name = "DeleteEnvironmentMembership",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$delete_environment_membership_input(environmentId = environmentId, userArn = userArn)
  output <- .cloud9$delete_environment_membership_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$delete_environment_membership <- cloud9_delete_environment_membership

#' Gets information about environment members for an AWS Cloud9 development
#' environment
#'
#' @description
#' Gets information about environment members for an AWS Cloud9 development
#' environment.
#'
#' @usage
#' cloud9_describe_environment_memberships(userArn, environmentId,
#'   permissions, nextToken, maxResults)
#'
#' @param userArn The Amazon Resource Name (ARN) of an individual environment member to
#' get information about. If no value is specified, information about all
#' environment members are returned.
#' @param environmentId The ID of the environment to get environment member information about.
#' @param permissions The type of environment member permissions to get information about.
#' Available values include:
#' 
#' -   `owner`: Owns the environment.
#' 
#' -   `read-only`: Has read-only access to the environment.
#' 
#' -   `read-write`: Has read-write access to the environment.
#' 
#' If no value is specified, information about all environment members are
#' returned.
#' @param nextToken During a previous call, if there are more than 25 items in the list,
#' only the first 25 items are returned, along with a unique string called
#' a *next token*. To get the next batch of items in the list, call this
#' operation again, adding the next token to the call. To get all of the
#' items in the list, keep calling this operation with each subsequent next
#' token that is returned, until no more next tokens are returned.
#' @param maxResults The maximum number of environment members to get information about.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   memberships = list(
#'     list(
#'       permissions = "owner"|"read-write"|"read-only",
#'       userId = "string",
#'       userArn = "string",
#'       environmentId = "string",
#'       lastAccess = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_environment_memberships(
#'   userArn = "string",
#'   environmentId = "string",
#'   permissions = list(
#'     "owner"|"read-write"|"read-only"
#'   ),
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example gets information about all of the environment
#' # members for the specified AWS Cloud9 development environment.
#' svc$describe_environment_memberships(
#'   environmentId = "8d9967e2f0624182b74e7690ad69ebEX"
#' )
#' 
#' # The following example gets information about the owner of the specified
#' # AWS Cloud9 development environment.
#' svc$describe_environment_memberships(
#'   environmentId = "8d9967e2f0624182b74e7690ad69ebEX",
#'   permissions = list(
#'     "owner"
#'   )
#' )
#' 
#' # The following example gets AWS Cloud9 development environment membership
#' # information for the specified user.
#' svc$describe_environment_memberships(
#'   userArn = "arn:aws:iam::123456789012:user/MyDemoUser"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname cloud9_describe_environment_memberships
cloud9_describe_environment_memberships <- function(userArn = NULL, environmentId = NULL, permissions = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentMemberships",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$describe_environment_memberships_input(userArn = userArn, environmentId = environmentId, permissions = permissions, nextToken = nextToken, maxResults = maxResults)
  output <- .cloud9$describe_environment_memberships_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$describe_environment_memberships <- cloud9_describe_environment_memberships

#' Gets status information for an AWS Cloud9 development environment
#'
#' @description
#' Gets status information for an AWS Cloud9 development environment.
#'
#' @usage
#' cloud9_describe_environment_status(environmentId)
#'
#' @param environmentId &#91;required&#93; The ID of the environment to get status information about.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   status = "error"|"creating"|"connecting"|"ready"|"stopping"|"stopped"|"deleting",
#'   message = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_environment_status(
#'   environmentId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # 
#' svc$describe_environment_status(
#'   environmentId = "8d9967e2f0624182b74e7690ad69ebEX"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname cloud9_describe_environment_status
cloud9_describe_environment_status <- function(environmentId) {
  op <- new_operation(
    name = "DescribeEnvironmentStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$describe_environment_status_input(environmentId = environmentId)
  output <- .cloud9$describe_environment_status_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$describe_environment_status <- cloud9_describe_environment_status

#' Gets information about AWS Cloud9 development environments
#'
#' @description
#' Gets information about AWS Cloud9 development environments.
#'
#' @usage
#' cloud9_describe_environments(environmentIds)
#'
#' @param environmentIds &#91;required&#93; The IDs of individual environments to get information about.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   environments = list(
#'     list(
#'       id = "string",
#'       name = "string",
#'       description = "string",
#'       type = "ssh"|"ec2",
#'       connectionType = "CONNECT_SSH"|"CONNECT_SSM",
#'       arn = "string",
#'       ownerArn = "string",
#'       lifecycle = list(
#'         status = "CREATING"|"CREATED"|"CREATE_FAILED"|"DELETING"|"DELETE_FAILED",
#'         reason = "string",
#'         failureResource = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_environments(
#'   environmentIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # 
#' svc$describe_environments(
#'   environmentIds = list(
#'     "8d9967e2f0624182b74e7690ad69ebEX",
#'     "349c86d4579e4e7298d500ff57a6b2EX"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname cloud9_describe_environments
cloud9_describe_environments <- function(environmentIds) {
  op <- new_operation(
    name = "DescribeEnvironments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$describe_environments_input(environmentIds = environmentIds)
  output <- .cloud9$describe_environments_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$describe_environments <- cloud9_describe_environments

#' Gets a list of AWS Cloud9 development environment identifiers
#'
#' @description
#' Gets a list of AWS Cloud9 development environment identifiers.
#'
#' @usage
#' cloud9_list_environments(nextToken, maxResults)
#'
#' @param nextToken During a previous call, if there are more than 25 items in the list,
#' only the first 25 items are returned, along with a unique string called
#' a *next token*. To get the next batch of items in the list, call this
#' operation again, adding the next token to the call. To get all of the
#' items in the list, keep calling this operation with each subsequent next
#' token that is returned, until no more next tokens are returned.
#' @param maxResults The maximum number of environments to get identifiers for.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   nextToken = "string",
#'   environmentIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_environments(
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # 
#' svc$list_environments()
#' }
#'
#' @keywords internal
#'
#' @rdname cloud9_list_environments
cloud9_list_environments <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListEnvironments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$list_environments_input(nextToken = nextToken, maxResults = maxResults)
  output <- .cloud9$list_environments_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$list_environments <- cloud9_list_environments

#' Gets a list of the tags associated with an AWS Cloud9 development
#' environment
#'
#' @description
#' Gets a list of the tags associated with an AWS Cloud9 development
#' environment.
#'
#' @usage
#' cloud9_list_tags_for_resource(ResourceARN)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Cloud9 development environment
#' to get the tags for.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloud9_list_tags_for_resource
cloud9_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .cloud9$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$list_tags_for_resource <- cloud9_list_tags_for_resource

#' Adds tags to an AWS Cloud9 development environment
#'
#' @description
#' Adds tags to an AWS Cloud9 development environment.
#' 
#' Tags that you add to an AWS Cloud9 environment by using this method will
#' NOT be automatically propagated to underlying resources.
#'
#' @usage
#' cloud9_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Cloud9 development environment
#' to add tags to.
#' @param Tags &#91;required&#93; The list of tags to add to the given AWS Cloud9 development environment.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloud9_tag_resource
cloud9_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .cloud9$tag_resource_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$tag_resource <- cloud9_tag_resource

#' Removes tags from an AWS Cloud9 development environment
#'
#' @description
#' Removes tags from an AWS Cloud9 development environment.
#'
#' @usage
#' cloud9_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Cloud9 development environment
#' to remove tags from.
#' @param TagKeys &#91;required&#93; The tag names of the tags to remove from the given AWS Cloud9
#' development environment.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloud9_untag_resource
cloud9_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .cloud9$untag_resource_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$untag_resource <- cloud9_untag_resource

#' Changes the settings of an existing AWS Cloud9 development environment
#'
#' @description
#' Changes the settings of an existing AWS Cloud9 development environment.
#'
#' @usage
#' cloud9_update_environment(environmentId, name, description)
#'
#' @param environmentId &#91;required&#93; The ID of the environment to change settings.
#' @param name A replacement name for the environment.
#' @param description Any new or replacement description for the environment.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_environment(
#'   environmentId = "string",
#'   name = "string",
#'   description = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # 
#' svc$update_environment(
#'   name = "my-changed-demo-environment",
#'   description = "This is my changed demonstration environment.",
#'   environmentId = "8d9967e2f0624182b74e7690ad69ebEX"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname cloud9_update_environment
cloud9_update_environment <- function(environmentId, name = NULL, description = NULL) {
  op <- new_operation(
    name = "UpdateEnvironment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$update_environment_input(environmentId = environmentId, name = name, description = description)
  output <- .cloud9$update_environment_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$update_environment <- cloud9_update_environment

#' Changes the settings of an existing environment member for an AWS Cloud9
#' development environment
#'
#' @description
#' Changes the settings of an existing environment member for an AWS Cloud9
#' development environment.
#'
#' @usage
#' cloud9_update_environment_membership(environmentId, userArn,
#'   permissions)
#'
#' @param environmentId &#91;required&#93; The ID of the environment for the environment member whose settings you
#' want to change.
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) of the environment member whose settings
#' you want to change.
#' @param permissions &#91;required&#93; The replacement type of environment member permissions you want to
#' associate with this environment member. Available values include:
#' 
#' -   `read-only`: Has read-only access to the environment.
#' 
#' -   `read-write`: Has read-write access to the environment.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   membership = list(
#'     permissions = "owner"|"read-write"|"read-only",
#'     userId = "string",
#'     userArn = "string",
#'     environmentId = "string",
#'     lastAccess = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_environment_membership(
#'   environmentId = "string",
#'   userArn = "string",
#'   permissions = "read-write"|"read-only"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # 
#' svc$update_environment_membership(
#'   environmentId = "8d9967e2f0624182b74e7690ad69ebEX",
#'   permissions = "read-only",
#'   userArn = "arn:aws:iam::123456789012:user/AnotherDemoUser"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname cloud9_update_environment_membership
cloud9_update_environment_membership <- function(environmentId, userArn, permissions) {
  op <- new_operation(
    name = "UpdateEnvironmentMembership",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$update_environment_membership_input(environmentId = environmentId, userArn = userArn, permissions = permissions)
  output <- .cloud9$update_environment_membership_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$update_environment_membership <- cloud9_update_environment_membership
