% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_create_commit}
\alias{codecommit_create_commit}
\title{Creates a commit for a repository on the tip of a specified branch}
\usage{
codecommit_create_commit(repositoryName, branchName, parentCommitId,
  authorName, email, commitMessage, keepEmptyFolders, putFiles,
  deleteFiles, setFileModes)
}
\arguments{
\item{repositoryName}{[required] The name of the repository where you create the commit.}

\item{branchName}{[required] The name of the branch where you create the commit.}

\item{parentCommitId}{The ID of the commit that is the parent of the commit you create. Not
required if this is an empty repository.}

\item{authorName}{The name of the author who created the commit. This information is used
as both the author and committer for the commit.}

\item{email}{The email address of the person who created the commit.}

\item{commitMessage}{The commit message you want to include in the commit. Commit messages
are limited to 256 KB. If no message is specified, a default message is
used.}

\item{keepEmptyFolders}{If the commit contains deletions, whether to keep a folder or folder
structure if the changes leave the folders empty. If true, a ..gitkeep
file is created for empty folders. The default is false.}

\item{putFiles}{The files to add or update in this commit.}

\item{deleteFiles}{The files to delete in this commit. These files still exist in earlier
commits.}

\item{setFileModes}{The file modes to update for files in this commit.}
}
\value{
A list with the following syntax:\preformatted{list(
  commitId = "string",
  treeId = "string",
  filesAdded = list(
    list(
      absolutePath = "string",
      blobId = "string",
      fileMode = "EXECUTABLE"|"NORMAL"|"SYMLINK"
    )
  ),
  filesUpdated = list(
    list(
      absolutePath = "string",
      blobId = "string",
      fileMode = "EXECUTABLE"|"NORMAL"|"SYMLINK"
    )
  ),
  filesDeleted = list(
    list(
      absolutePath = "string",
      blobId = "string",
      fileMode = "EXECUTABLE"|"NORMAL"|"SYMLINK"
    )
  )
)
}
}
\description{
Creates a commit for a repository on the tip of a specified branch.
}
\section{Request syntax}{
\preformatted{svc$create_commit(
  repositoryName = "string",
  branchName = "string",
  parentCommitId = "string",
  authorName = "string",
  email = "string",
  commitMessage = "string",
  keepEmptyFolders = TRUE|FALSE,
  putFiles = list(
    list(
      filePath = "string",
      fileMode = "EXECUTABLE"|"NORMAL"|"SYMLINK",
      fileContent = raw,
      sourceFile = list(
        filePath = "string",
        isMove = TRUE|FALSE
      )
    )
  ),
  deleteFiles = list(
    list(
      filePath = "string"
    )
  ),
  setFileModes = list(
    list(
      filePath = "string",
      fileMode = "EXECUTABLE"|"NORMAL"|"SYMLINK"
    )
  )
)
}
}

\keyword{internal}
