% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_create_unreferenced_merge_commit}
\alias{codecommit_create_unreferenced_merge_commit}
\title{Creates an unreferenced commit that represents the result of merging two
branches using a specified merge strategy}
\usage{
codecommit_create_unreferenced_merge_commit(repositoryName,
  sourceCommitSpecifier, destinationCommitSpecifier, mergeOption,
  conflictDetailLevel, conflictResolutionStrategy, authorName, email,
  commitMessage, keepEmptyFolders, conflictResolution)
}
\arguments{
\item{repositoryName}{[required] The name of the repository where you want to create the unreferenced
merge commit.}

\item{sourceCommitSpecifier}{[required] The branch, tag, HEAD, or other fully qualified reference used to
identify a commit (for example, a branch name or a full commit ID).}

\item{destinationCommitSpecifier}{[required] The branch, tag, HEAD, or other fully qualified reference used to
identify a commit (for example, a branch name or a full commit ID).}

\item{mergeOption}{[required] The merge option or strategy you want to use to merge the code.}

\item{conflictDetailLevel}{The level of conflict detail to use. If unspecified, the default
FILE_LEVEL is used, which returns a not-mergeable result if the same
file has differences in both branches. If LINE_LEVEL is specified, a
conflict is considered not mergeable if the same file in both branches
has differences on the same line.}

\item{conflictResolutionStrategy}{Specifies which branch to use when resolving conflicts, or whether to
attempt automatically merging two versions of a file. The default is
NONE, which requires any conflicts to be resolved manually before the
merge operation is successful.}

\item{authorName}{The name of the author who created the unreferenced commit. This
information is used as both the author and committer for the commit.}

\item{email}{The email address for the person who created the unreferenced commit.}

\item{commitMessage}{The commit message for the unreferenced commit.}

\item{keepEmptyFolders}{If the commit contains deletions, whether to keep a folder or folder
structure if the changes leave the folders empty. If this is specified
as true, a .gitkeep file is created for empty folders. The default is
false.}

\item{conflictResolution}{If AUTOMERGE is the conflict resolution strategy, a list of inputs to
use when resolving conflicts during a merge.}
}
\value{
A list with the following syntax:\preformatted{list(
  commitId = "string",
  treeId = "string"
)
}
}
\description{
Creates an unreferenced commit that represents the result of merging two
branches using a specified merge strategy. This can help you determine
the outcome of a potential merge. This API cannot be used with the
fast-forward merge strategy because that strategy does not create a
merge commit.

This unreferenced merge commit can only be accessed using the GetCommit
API or through git commands such as git fetch. To retrieve this commit,
you must specify its commit ID or otherwise reference it.
}
\section{Request syntax}{
\preformatted{svc$create_unreferenced_merge_commit(
  repositoryName = "string",
  sourceCommitSpecifier = "string",
  destinationCommitSpecifier = "string",
  mergeOption = "FAST_FORWARD_MERGE"|"SQUASH_MERGE"|"THREE_WAY_MERGE",
  conflictDetailLevel = "FILE_LEVEL"|"LINE_LEVEL",
  conflictResolutionStrategy = "NONE"|"ACCEPT_SOURCE"|"ACCEPT_DESTINATION"|"AUTOMERGE",
  authorName = "string",
  email = "string",
  commitMessage = "string",
  keepEmptyFolders = TRUE|FALSE,
  conflictResolution = list(
    replaceContents = list(
      list(
        filePath = "string",
        replacementType = "KEEP_BASE"|"KEEP_SOURCE"|"KEEP_DESTINATION"|"USE_NEW_CONTENT",
        content = raw,
        fileMode = "EXECUTABLE"|"NORMAL"|"SYMLINK"
      )
    ),
    deleteFiles = list(
      list(
        filePath = "string"
      )
    ),
    setFileModes = list(
      list(
        filePath = "string",
        fileMode = "EXECUTABLE"|"NORMAL"|"SYMLINK"
      )
    )
  )
)
}
}

\keyword{internal}
