% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_delete_custom_action_type}
\alias{codepipeline_delete_custom_action_type}
\title{Marks a custom action as deleted}
\usage{
codepipeline_delete_custom_action_type(category, provider, version)
}
\arguments{
\item{category}{[required] The category of the custom action that you want to delete, such as
source or deploy.}

\item{provider}{[required] The provider of the service used in the custom action, such as AWS
CodeDeploy.}

\item{version}{[required] The version of the custom action to delete.}
}
\value{
An empty list.
}
\description{
Marks a custom action as deleted.
\code{\link[=codepipeline_poll_for_jobs]{poll_for_jobs}} for the custom action
fails after the action is marked for deletion. Used for custom actions
only.

To re-create a custom action after it has been deleted you must use a
string in the version field that has never been used before. This string
can be an incremented version number, for example. To restore a deleted
custom action, use a JSON file that is identical to the deleted action,
including the original string in the version field.
}
\section{Request syntax}{
\preformatted{svc$delete_custom_action_type(
  category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
  provider = "string",
  version = "string"
)
}
}

\keyword{internal}
