% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_list_report_groups}
\alias{codebuild_list_report_groups}
\title{Gets a list ARNs for the report groups in the current Amazon Web
Services account}
\usage{
codebuild_list_report_groups(
  sortOrder = NULL,
  sortBy = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{sortOrder}{Used to specify the order to sort the list of returned report groups.
Valid values are \code{ASCENDING} and \code{DESCENDING}.}

\item{sortBy}{The criterion to be used to list build report groups. Valid values
include:
\itemize{
\item \code{CREATED_TIME}: List based on when each report group was created.
\item \code{LAST_MODIFIED_TIME}: List based on when each report group was last
changed.
\item \code{NAME}: List based on each report group's name.
}}

\item{nextToken}{During a previous call, the maximum number of items that can be returned
is the value specified in \code{maxResults}. If there more items in the list,
then a unique string called a \emph{nextToken} is returned. To get the next
batch of items in the list, call this operation again, adding the next
token to the call. To get all of the items in the list, keep calling
this operation with each subsequent next token that is returned, until
no more next tokens are returned.}

\item{maxResults}{The maximum number of paginated report groups returned per response. Use
\code{nextToken} to iterate pages in the list of returned \code{ReportGroup}
objects. The default value is 100.}
}
\description{
Gets a list ARNs for the report groups in the current Amazon Web Services account.

See \url{https://paws-r.github.io/docs/codebuild/list_report_groups.html} for full documentation.
}
\keyword{internal}
