% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_delete_file}
\alias{codecommit_delete_file}
\title{Deletes a specified file from a specified branch}
\usage{
codecommit_delete_file(
  repositoryName,
  branchName,
  filePath,
  parentCommitId,
  keepEmptyFolders = NULL,
  commitMessage = NULL,
  name = NULL,
  email = NULL
)
}
\arguments{
\item{repositoryName}{[required] The name of the repository that contains the file to delete.}

\item{branchName}{[required] The name of the branch where the commit that deletes the file is made.}

\item{filePath}{[required] The fully qualified path to the file that to be deleted, including the
full name and extension of that file. For example, /examples/file.md is
a fully qualified path to a file named file.md in a folder named
examples.}

\item{parentCommitId}{[required] The ID of the commit that is the tip of the branch where you want to
create the commit that deletes the file. This must be the HEAD commit
for the branch. The commit that deletes the file is created from this
commit ID.}

\item{keepEmptyFolders}{If a file is the only object in the folder or directory, specifies
whether to delete the folder or directory that contains the file. By
default, empty folders are deleted. This includes empty folders that are
part of the directory structure. For example, if the path to a file is
dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file
in dir4 also deletes the empty folders dir4, dir3, and dir2.}

\item{commitMessage}{The commit message you want to include as part of deleting the file.
Commit messages are limited to 256 KB. If no message is specified, a
default message is used.}

\item{name}{The name of the author of the commit that deletes the file. If no name
is specified, the user's ARN is used as the author name and committer
name.}

\item{email}{The email address for the commit that deletes the file. If no email
address is specified, the email address is left blank.}
}
\description{
Deletes a specified file from a specified branch. A commit is created on the branch that contains the revision. The file still exists in the commits earlier to the commit that contains the deletion.

See \url{https://paws-r.github.io/docs/codecommit/delete_file.html} for full documentation.
}
\keyword{internal}
