% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_describe_merge_conflicts}
\alias{codecommit_describe_merge_conflicts}
\title{Returns information about one or more merge conflicts in the attempted
merge of two commit specifiers using the squash or three-way merge
strategy}
\usage{
codecommit_describe_merge_conflicts(
  repositoryName,
  destinationCommitSpecifier,
  sourceCommitSpecifier,
  mergeOption,
  maxMergeHunks = NULL,
  filePath,
  conflictDetailLevel = NULL,
  conflictResolutionStrategy = NULL,
  nextToken = NULL
)
}
\arguments{
\item{repositoryName}{[required] The name of the repository where you want to get information about a
merge conflict.}

\item{destinationCommitSpecifier}{[required] The branch, tag, HEAD, or other fully qualified reference used to
identify a commit (for example, a branch name or a full commit ID).}

\item{sourceCommitSpecifier}{[required] The branch, tag, HEAD, or other fully qualified reference used to
identify a commit (for example, a branch name or a full commit ID).}

\item{mergeOption}{[required] The merge option or strategy you want to use to merge the code.}

\item{maxMergeHunks}{The maximum number of merge hunks to include in the output.}

\item{filePath}{[required] The path of the target files used to describe the conflicts.}

\item{conflictDetailLevel}{The level of conflict detail to use. If unspecified, the default
FILE_LEVEL is used, which returns a not-mergeable result if the same
file has differences in both branches. If LINE_LEVEL is specified, a
conflict is considered not mergeable if the same file in both branches
has differences on the same line.}

\item{conflictResolutionStrategy}{Specifies which branch to use when resolving conflicts, or whether to
attempt automatically merging two versions of a file. The default is
NONE, which requires any conflicts to be resolved manually before the
merge operation is successful.}

\item{nextToken}{An enumeration token that, when provided in a request, returns the next
batch of the results.}
}
\description{
Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy. If the merge option for the attempted merge is specified as FAST_FORWARD_MERGE, an exception is thrown.

See \url{https://paws-r.github.io/docs/codecommit/describe_merge_conflicts.html} for full documentation.
}
\keyword{internal}
