% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_put_job_success_result}
\alias{codepipeline_put_job_success_result}
\title{Represents the success of a job as returned to the pipeline by a job
worker}
\usage{
codepipeline_put_job_success_result(
  jobId,
  currentRevision = NULL,
  continuationToken = NULL,
  executionDetails = NULL,
  outputVariables = NULL
)
}
\arguments{
\item{jobId}{[required] The unique system-generated ID of the job that succeeded. This is the
same ID returned from \code{\link[=codepipeline_poll_for_jobs]{poll_for_jobs}}.}

\item{currentRevision}{The ID of the current revision of the artifact successfully worked on by
the job.}

\item{continuationToken}{A token generated by a job worker, such as an AWS CodeDeploy deployment
ID, that a successful job provides to identify a custom action in
progress. Future jobs use this token to identify the running instance of
the action. It can be reused to return more information about the
progress of the custom action. When the action is complete, no
continuation token should be supplied.}

\item{executionDetails}{The execution details of the successful job, such as the actions taken
by the job worker.}

\item{outputVariables}{Key-value pairs produced as output by a job worker that can be made
available to a downstream action configuration. \code{outputVariables} can be
included only when there is no continuation token on the request.}
}
\description{
Represents the success of a job as returned to the pipeline by a job worker. Used for custom actions only.

See \url{https://paws-r.github.io/docs/codepipeline/put_job_success_result.html} for full documentation.
}
\keyword{internal}
