# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codecatalyst_service.R
NULL

#' Creates a personal access token (PAT) for the current user
#'
#' @description
#' Creates a personal access token (PAT) for the current user. A personal access token (PAT) is similar to a password. It is associated with your user identity for use across all spaces and projects in Amazon CodeCatalyst. You use PATs to access CodeCatalyst from resources that include integrated development environments (IDEs) and Git-based source repositories. PATs represent you in Amazon CodeCatalyst and you can manage them in your user settings.For more information, see [Managing personal access tokens in Amazon CodeCatalyst](https://docs.aws.amazon.com/codecatalyst/latest/userguide/ipa-tokens-keys.html).
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_create_access_token/](https://www.paws-r-sdk.com/docs/codecatalyst_create_access_token/) for full documentation.
#'
#' @param name &#91;required&#93; The friendly name of the personal access token.
#' @param expiresTime The date and time the personal access token expires, in coordinated
#' universal time (UTC) timestamp format as specified in [RFC
#' 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
#'
#' @keywords internal
#'
#' @rdname codecatalyst_create_access_token
codecatalyst_create_access_token <- function(name, expiresTime = NULL) {
  op <- new_operation(
    name = "CreateAccessToken",
    http_method = "PUT",
    http_path = "/v1/accessTokens",
    paginator = list()
  )
  input <- .codecatalyst$create_access_token_input(name = name, expiresTime = expiresTime)
  output <- .codecatalyst$create_access_token_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$create_access_token <- codecatalyst_create_access_token

#' Creates a Dev Environment in Amazon CodeCatalyst, a cloud-based
#' development environment that you can use to quickly work on the code
#' stored in the source repositories of your project
#'
#' @description
#' Creates a Dev Environment in Amazon CodeCatalyst, a cloud-based development environment that you can use to quickly work on the code stored in the source repositories of your project.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_create_dev_environment/](https://www.paws-r-sdk.com/docs/codecatalyst_create_dev_environment/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param repositories The source repository that contains the branch to clone into the Dev
#' Environment.
#' @param clientToken A user-specified idempotency token. Idempotency ensures that an API
#' request completes only once. With an idempotent request, if the original
#' request completes successfully, the subsequent retries return the result
#' from the original successful request and have no additional effect.
#' @param alias The user-defined alias for a Dev Environment.
#' @param ides Information about the integrated development environment (IDE)
#' configured for a Dev Environment.
#' 
#' An IDE is required to create a Dev Environment. For Dev Environment
#' creation, this field contains configuration information and must be
#' provided.
#' @param instanceType &#91;required&#93; The Amazon EC2 instace type to use for the Dev Environment.
#' @param inactivityTimeoutMinutes The amount of time the Dev Environment will run without any activity
#' detected before stopping, in minutes. Only whole integers are allowed.
#' Dev Environments consume compute minutes when running.
#' @param persistentStorage &#91;required&#93; Information about the amount of storage allocated to the Dev
#' Environment.
#' 
#' By default, a Dev Environment is configured to have 16GB of persistent
#' storage when created from the Amazon CodeCatalyst console, but there is
#' no default when programmatically creating a Dev Environment. Valid
#' values for persistent storage are based on memory sizes in 16GB
#' increments. Valid values are 16, 32, and 64.
#' @param vpcConnectionName The name of the connection that will be used to connect to Amazon VPC,
#' if any.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_create_dev_environment
codecatalyst_create_dev_environment <- function(spaceName, projectName, repositories = NULL, clientToken = NULL, alias = NULL, ides = NULL, instanceType, inactivityTimeoutMinutes = NULL, persistentStorage, vpcConnectionName = NULL) {
  op <- new_operation(
    name = "CreateDevEnvironment",
    http_method = "PUT",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/devEnvironments",
    paginator = list()
  )
  input <- .codecatalyst$create_dev_environment_input(spaceName = spaceName, projectName = projectName, repositories = repositories, clientToken = clientToken, alias = alias, ides = ides, instanceType = instanceType, inactivityTimeoutMinutes = inactivityTimeoutMinutes, persistentStorage = persistentStorage, vpcConnectionName = vpcConnectionName)
  output <- .codecatalyst$create_dev_environment_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$create_dev_environment <- codecatalyst_create_dev_environment

#' Creates a project in a specified space
#'
#' @description
#' Creates a project in a specified space.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_create_project/](https://www.paws-r-sdk.com/docs/codecatalyst_create_project/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param displayName &#91;required&#93; The friendly name of the project that will be displayed to users.
#' @param description The description of the project. This description will be displayed to
#' all users of the project. We recommend providing a brief description of
#' the project and its intended purpose.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_create_project
codecatalyst_create_project <- function(spaceName, displayName, description = NULL) {
  op <- new_operation(
    name = "CreateProject",
    http_method = "PUT",
    http_path = "/v1/spaces/{spaceName}/projects",
    paginator = list()
  )
  input <- .codecatalyst$create_project_input(spaceName = spaceName, displayName = displayName, description = description)
  output <- .codecatalyst$create_project_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$create_project <- codecatalyst_create_project

#' Creates an empty Git-based source repository in a specified project
#'
#' @description
#' Creates an empty Git-based source repository in a specified project. The repository is created with an initial empty commit with a default branch named `main`.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_create_source_repository/](https://www.paws-r-sdk.com/docs/codecatalyst_create_source_repository/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param name &#91;required&#93; The name of the source repository. For more information about name
#' requirements, see [Quotas for source
#' repositories](https://docs.aws.amazon.com/codecatalyst/latest/userguide/source-quotas.html).
#' @param description The description of the source repository.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_create_source_repository
codecatalyst_create_source_repository <- function(spaceName, projectName, name, description = NULL) {
  op <- new_operation(
    name = "CreateSourceRepository",
    http_method = "PUT",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/sourceRepositories/{name}",
    paginator = list()
  )
  input <- .codecatalyst$create_source_repository_input(spaceName = spaceName, projectName = projectName, name = name, description = description)
  output <- .codecatalyst$create_source_repository_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$create_source_repository <- codecatalyst_create_source_repository

#' Creates a branch in a specified source repository in Amazon CodeCatalyst
#'
#' @description
#' Creates a branch in a specified source repository in Amazon CodeCatalyst.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_create_source_repository_branch/](https://www.paws-r-sdk.com/docs/codecatalyst_create_source_repository_branch/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param sourceRepositoryName &#91;required&#93; The name of the repository where you want to create a branch.
#' @param name &#91;required&#93; The name for the branch you're creating.
#' @param headCommitId The commit ID in an existing branch from which you want to create the
#' new branch.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_create_source_repository_branch
codecatalyst_create_source_repository_branch <- function(spaceName, projectName, sourceRepositoryName, name, headCommitId = NULL) {
  op <- new_operation(
    name = "CreateSourceRepositoryBranch",
    http_method = "PUT",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/sourceRepositories/{sourceRepositoryName}/branches/{name}",
    paginator = list()
  )
  input <- .codecatalyst$create_source_repository_branch_input(spaceName = spaceName, projectName = projectName, sourceRepositoryName = sourceRepositoryName, name = name, headCommitId = headCommitId)
  output <- .codecatalyst$create_source_repository_branch_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$create_source_repository_branch <- codecatalyst_create_source_repository_branch

#' Deletes a specified personal access token (PAT)
#'
#' @description
#' Deletes a specified personal access token (PAT). A personal access token can only be deleted by the user who created it.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_delete_access_token/](https://www.paws-r-sdk.com/docs/codecatalyst_delete_access_token/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the personal access token to delete. You can find the IDs of
#' all PATs associated with your Amazon Web Services Builder ID in a space
#' by calling [`list_access_tokens`][codecatalyst_list_access_tokens].
#'
#' @keywords internal
#'
#' @rdname codecatalyst_delete_access_token
codecatalyst_delete_access_token <- function(id) {
  op <- new_operation(
    name = "DeleteAccessToken",
    http_method = "DELETE",
    http_path = "/v1/accessTokens/{id}",
    paginator = list()
  )
  input <- .codecatalyst$delete_access_token_input(id = id)
  output <- .codecatalyst$delete_access_token_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$delete_access_token <- codecatalyst_delete_access_token

#' Deletes a Dev Environment
#'
#' @description
#' Deletes a Dev Environment.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_delete_dev_environment/](https://www.paws-r-sdk.com/docs/codecatalyst_delete_dev_environment/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param id &#91;required&#93; The system-generated unique ID of the Dev Environment you want to
#' delete. To retrieve a list of Dev Environment IDs, use
#' [`list_dev_environments`][codecatalyst_list_dev_environments].
#'
#' @keywords internal
#'
#' @rdname codecatalyst_delete_dev_environment
codecatalyst_delete_dev_environment <- function(spaceName, projectName, id) {
  op <- new_operation(
    name = "DeleteDevEnvironment",
    http_method = "DELETE",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/devEnvironments/{id}",
    paginator = list()
  )
  input <- .codecatalyst$delete_dev_environment_input(spaceName = spaceName, projectName = projectName, id = id)
  output <- .codecatalyst$delete_dev_environment_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$delete_dev_environment <- codecatalyst_delete_dev_environment

#' Deletes a project in a space
#'
#' @description
#' Deletes a project in a space.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_delete_project/](https://www.paws-r-sdk.com/docs/codecatalyst_delete_project/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param name &#91;required&#93; The name of the project in the space. To retrieve a list of project
#' names, use [`list_projects`][codecatalyst_list_projects].
#'
#' @keywords internal
#'
#' @rdname codecatalyst_delete_project
codecatalyst_delete_project <- function(spaceName, name) {
  op <- new_operation(
    name = "DeleteProject",
    http_method = "DELETE",
    http_path = "/v1/spaces/{spaceName}/projects/{name}",
    paginator = list()
  )
  input <- .codecatalyst$delete_project_input(spaceName = spaceName, name = name)
  output <- .codecatalyst$delete_project_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$delete_project <- codecatalyst_delete_project

#' Deletes a source repository in Amazon CodeCatalyst
#'
#' @description
#' Deletes a source repository in Amazon CodeCatalyst. You cannot use this API to delete a linked repository. It can only be used to delete a Amazon CodeCatalyst source repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_delete_source_repository/](https://www.paws-r-sdk.com/docs/codecatalyst_delete_source_repository/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param name &#91;required&#93; The name of the source repository.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_delete_source_repository
codecatalyst_delete_source_repository <- function(spaceName, projectName, name) {
  op <- new_operation(
    name = "DeleteSourceRepository",
    http_method = "DELETE",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/sourceRepositories/{name}",
    paginator = list()
  )
  input <- .codecatalyst$delete_source_repository_input(spaceName = spaceName, projectName = projectName, name = name)
  output <- .codecatalyst$delete_source_repository_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$delete_source_repository <- codecatalyst_delete_source_repository

#' Deletes a space
#'
#' @description
#' Deletes a space.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_delete_space/](https://www.paws-r-sdk.com/docs/codecatalyst_delete_space/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the space. To retrieve a list of space names, use
#' [`list_spaces`][codecatalyst_list_spaces].
#'
#' @keywords internal
#'
#' @rdname codecatalyst_delete_space
codecatalyst_delete_space <- function(name) {
  op <- new_operation(
    name = "DeleteSpace",
    http_method = "DELETE",
    http_path = "/v1/spaces/{name}",
    paginator = list()
  )
  input <- .codecatalyst$delete_space_input(name = name)
  output <- .codecatalyst$delete_space_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$delete_space <- codecatalyst_delete_space

#' Returns information about a Dev Environment for a source repository in a
#' project
#'
#' @description
#' Returns information about a Dev Environment for a source repository in a project. Dev Environments are specific to the user who creates them.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_get_dev_environment/](https://www.paws-r-sdk.com/docs/codecatalyst_get_dev_environment/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param id &#91;required&#93; The system-generated unique ID of the Dev Environment for which you want
#' to view information. To retrieve a list of Dev Environment IDs, use
#' [`list_dev_environments`][codecatalyst_list_dev_environments].
#'
#' @keywords internal
#'
#' @rdname codecatalyst_get_dev_environment
codecatalyst_get_dev_environment <- function(spaceName, projectName, id) {
  op <- new_operation(
    name = "GetDevEnvironment",
    http_method = "GET",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/devEnvironments/{id}",
    paginator = list()
  )
  input <- .codecatalyst$get_dev_environment_input(spaceName = spaceName, projectName = projectName, id = id)
  output <- .codecatalyst$get_dev_environment_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$get_dev_environment <- codecatalyst_get_dev_environment

#' Returns information about a project
#'
#' @description
#' Returns information about a project.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_get_project/](https://www.paws-r-sdk.com/docs/codecatalyst_get_project/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param name &#91;required&#93; The name of the project in the space.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_get_project
codecatalyst_get_project <- function(spaceName, name) {
  op <- new_operation(
    name = "GetProject",
    http_method = "GET",
    http_path = "/v1/spaces/{spaceName}/projects/{name}",
    paginator = list()
  )
  input <- .codecatalyst$get_project_input(spaceName = spaceName, name = name)
  output <- .codecatalyst$get_project_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$get_project <- codecatalyst_get_project

#' Returns information about a source repository
#'
#' @description
#' Returns information about a source repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_get_source_repository/](https://www.paws-r-sdk.com/docs/codecatalyst_get_source_repository/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param name &#91;required&#93; The name of the source repository.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_get_source_repository
codecatalyst_get_source_repository <- function(spaceName, projectName, name) {
  op <- new_operation(
    name = "GetSourceRepository",
    http_method = "GET",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/sourceRepositories/{name}",
    paginator = list()
  )
  input <- .codecatalyst$get_source_repository_input(spaceName = spaceName, projectName = projectName, name = name)
  output <- .codecatalyst$get_source_repository_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$get_source_repository <- codecatalyst_get_source_repository

#' Returns information about the URLs that can be used with a Git client to
#' clone a source repository
#'
#' @description
#' Returns information about the URLs that can be used with a Git client to clone a source repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_get_source_repository_clone_urls/](https://www.paws-r-sdk.com/docs/codecatalyst_get_source_repository_clone_urls/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param sourceRepositoryName &#91;required&#93; The name of the source repository.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_get_source_repository_clone_urls
codecatalyst_get_source_repository_clone_urls <- function(spaceName, projectName, sourceRepositoryName) {
  op <- new_operation(
    name = "GetSourceRepositoryCloneUrls",
    http_method = "GET",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/sourceRepositories/{sourceRepositoryName}/cloneUrls",
    paginator = list()
  )
  input <- .codecatalyst$get_source_repository_clone_urls_input(spaceName = spaceName, projectName = projectName, sourceRepositoryName = sourceRepositoryName)
  output <- .codecatalyst$get_source_repository_clone_urls_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$get_source_repository_clone_urls <- codecatalyst_get_source_repository_clone_urls

#' Returns information about an space
#'
#' @description
#' Returns information about an space.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_get_space/](https://www.paws-r-sdk.com/docs/codecatalyst_get_space/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the space.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_get_space
codecatalyst_get_space <- function(name) {
  op <- new_operation(
    name = "GetSpace",
    http_method = "GET",
    http_path = "/v1/spaces/{name}",
    paginator = list()
  )
  input <- .codecatalyst$get_space_input(name = name)
  output <- .codecatalyst$get_space_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$get_space <- codecatalyst_get_space

#' Returns information about the Amazon Web Services account used for
#' billing purposes and the billing plan for the space
#'
#' @description
#' Returns information about the Amazon Web Services account used for billing purposes and the billing plan for the space.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_get_subscription/](https://www.paws-r-sdk.com/docs/codecatalyst_get_subscription/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_get_subscription
codecatalyst_get_subscription <- function(spaceName) {
  op <- new_operation(
    name = "GetSubscription",
    http_method = "GET",
    http_path = "/v1/spaces/{spaceName}/subscription",
    paginator = list()
  )
  input <- .codecatalyst$get_subscription_input(spaceName = spaceName)
  output <- .codecatalyst$get_subscription_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$get_subscription <- codecatalyst_get_subscription

#' Returns information about a user
#'
#' @description
#' Returns information about a user.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_get_user_details/](https://www.paws-r-sdk.com/docs/codecatalyst_get_user_details/) for full documentation.
#'
#' @param id The system-generated unique ID of the user.
#' @param userName The name of the user as displayed in Amazon CodeCatalyst.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_get_user_details
codecatalyst_get_user_details <- function(id = NULL, userName = NULL) {
  op <- new_operation(
    name = "GetUserDetails",
    http_method = "GET",
    http_path = "/userDetails",
    paginator = list()
  )
  input <- .codecatalyst$get_user_details_input(id = id, userName = userName)
  output <- .codecatalyst$get_user_details_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$get_user_details <- codecatalyst_get_user_details

#' Returns information about a workflow
#'
#' @description
#' Returns information about a workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_get_workflow/](https://www.paws-r-sdk.com/docs/codecatalyst_get_workflow/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param id &#91;required&#93; The ID of the workflow. To rerieve a list of workflow IDs, use
#' [`list_workflows`][codecatalyst_list_workflows].
#' @param projectName &#91;required&#93; The name of the project in the space.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_get_workflow
codecatalyst_get_workflow <- function(spaceName, id, projectName) {
  op <- new_operation(
    name = "GetWorkflow",
    http_method = "GET",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/workflows/{id}",
    paginator = list()
  )
  input <- .codecatalyst$get_workflow_input(spaceName = spaceName, id = id, projectName = projectName)
  output <- .codecatalyst$get_workflow_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$get_workflow <- codecatalyst_get_workflow

#' Returns information about a specified run of a workflow
#'
#' @description
#' Returns information about a specified run of a workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_get_workflow_run/](https://www.paws-r-sdk.com/docs/codecatalyst_get_workflow_run/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param id &#91;required&#93; The ID of the workflow run. To retrieve a list of workflow run IDs, use
#' [`list_workflow_runs`][codecatalyst_list_workflow_runs].
#' @param projectName &#91;required&#93; The name of the project in the space.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_get_workflow_run
codecatalyst_get_workflow_run <- function(spaceName, id, projectName) {
  op <- new_operation(
    name = "GetWorkflowRun",
    http_method = "GET",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/workflowRuns/{id}",
    paginator = list()
  )
  input <- .codecatalyst$get_workflow_run_input(spaceName = spaceName, id = id, projectName = projectName)
  output <- .codecatalyst$get_workflow_run_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$get_workflow_run <- codecatalyst_get_workflow_run

#' Lists all personal access tokens (PATs) associated with the user who
#' calls the API
#'
#' @description
#' Lists all personal access tokens (PATs) associated with the user who calls the API. You can only list PATs associated with your Amazon Web Services Builder ID.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_list_access_tokens/](https://www.paws-r-sdk.com/docs/codecatalyst_list_access_tokens/) for full documentation.
#'
#' @param maxResults The maximum number of results to show in a single call to this API. If
#' the number of results is larger than the number you specified, the
#' response will include a `NextToken` element, which you can use to obtain
#' additional results.
#' @param nextToken A token returned from a call to this API to indicate the next batch of
#' results to return, if any.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_list_access_tokens
codecatalyst_list_access_tokens <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAccessTokens",
    http_method = "POST",
    http_path = "/v1/accessTokens",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .codecatalyst$list_access_tokens_input(maxResults = maxResults, nextToken = nextToken)
  output <- .codecatalyst$list_access_tokens_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$list_access_tokens <- codecatalyst_list_access_tokens

#' Retrieves a list of active sessions for a Dev Environment in a project
#'
#' @description
#' Retrieves a list of active sessions for a Dev Environment in a project.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_list_dev_environment_sessions/](https://www.paws-r-sdk.com/docs/codecatalyst_list_dev_environment_sessions/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param devEnvironmentId &#91;required&#93; The system-generated unique ID of the Dev Environment.
#' @param nextToken A token returned from a call to this API to indicate the next batch of
#' results to return, if any.
#' @param maxResults The maximum number of results to show in a single call to this API. If
#' the number of results is larger than the number you specified, the
#' response will include a `NextToken` element, which you can use to obtain
#' additional results.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_list_dev_environment_sessions
codecatalyst_list_dev_environment_sessions <- function(spaceName, projectName, devEnvironmentId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDevEnvironmentSessions",
    http_method = "POST",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/devEnvironments/{devEnvironmentId}/sessions",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .codecatalyst$list_dev_environment_sessions_input(spaceName = spaceName, projectName = projectName, devEnvironmentId = devEnvironmentId, nextToken = nextToken, maxResults = maxResults)
  output <- .codecatalyst$list_dev_environment_sessions_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$list_dev_environment_sessions <- codecatalyst_list_dev_environment_sessions

#' Retrieves a list of Dev Environments in a project
#'
#' @description
#' Retrieves a list of Dev Environments in a project.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_list_dev_environments/](https://www.paws-r-sdk.com/docs/codecatalyst_list_dev_environments/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName The name of the project in the space.
#' @param filters Information about filters to apply to narrow the results returned in the
#' list.
#' @param nextToken A token returned from a call to this API to indicate the next batch of
#' results to return, if any.
#' @param maxResults The maximum number of results to show in a single call to this API. If
#' the number of results is larger than the number you specified, the
#' response will include a `NextToken` element, which you can use to obtain
#' additional results.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_list_dev_environments
codecatalyst_list_dev_environments <- function(spaceName, projectName = NULL, filters = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDevEnvironments",
    http_method = "POST",
    http_path = "/v1/spaces/{spaceName}/devEnvironments",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .codecatalyst$list_dev_environments_input(spaceName = spaceName, projectName = projectName, filters = filters, nextToken = nextToken, maxResults = maxResults)
  output <- .codecatalyst$list_dev_environments_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$list_dev_environments <- codecatalyst_list_dev_environments

#' Retrieves a list of events that occurred during a specific time in a
#' space
#'
#' @description
#' Retrieves a list of events that occurred during a specific time in a space. You can use these events to audit user and system activity in a space. For more information, see [Monitoring](https://docs.aws.amazon.com/codecatalyst/latest/userguide/ipa-monitoring.html) in the *Amazon CodeCatalyst User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_list_event_logs/](https://www.paws-r-sdk.com/docs/codecatalyst_list_event_logs/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param startTime &#91;required&#93; The date and time when you want to start retrieving events, in
#' coordinated universal time (UTC) timestamp format as specified in [RFC
#' 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
#' @param endTime &#91;required&#93; The time after which you do not want any events retrieved, in
#' coordinated universal time (UTC) timestamp format as specified in [RFC
#' 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
#' @param eventName The name of the event.
#' @param nextToken A token returned from a call to this API to indicate the next batch of
#' results to return, if any.
#' @param maxResults The maximum number of results to show in a single call to this API. If
#' the number of results is larger than the number you specified, the
#' response will include a `NextToken` element, which you can use to obtain
#' additional results.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_list_event_logs
codecatalyst_list_event_logs <- function(spaceName, startTime, endTime, eventName = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListEventLogs",
    http_method = "POST",
    http_path = "/v1/spaces/{spaceName}/eventLogs",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .codecatalyst$list_event_logs_input(spaceName = spaceName, startTime = startTime, endTime = endTime, eventName = eventName, nextToken = nextToken, maxResults = maxResults)
  output <- .codecatalyst$list_event_logs_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$list_event_logs <- codecatalyst_list_event_logs

#' Retrieves a list of projects
#'
#' @description
#' Retrieves a list of projects.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_list_projects/](https://www.paws-r-sdk.com/docs/codecatalyst_list_projects/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param nextToken A token returned from a call to this API to indicate the next batch of
#' results to return, if any.
#' @param maxResults The maximum number of results to show in a single call to this API. If
#' the number of results is larger than the number you specified, the
#' response will include a `NextToken` element, which you can use to obtain
#' additional results.
#' @param filters Information about filters to apply to narrow the results returned in the
#' list.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_list_projects
codecatalyst_list_projects <- function(spaceName, nextToken = NULL, maxResults = NULL, filters = NULL) {
  op <- new_operation(
    name = "ListProjects",
    http_method = "POST",
    http_path = "/v1/spaces/{spaceName}/projects",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .codecatalyst$list_projects_input(spaceName = spaceName, nextToken = nextToken, maxResults = maxResults, filters = filters)
  output <- .codecatalyst$list_projects_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$list_projects <- codecatalyst_list_projects

#' Retrieves a list of source repositories in a project
#'
#' @description
#' Retrieves a list of source repositories in a project.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_list_source_repositories/](https://www.paws-r-sdk.com/docs/codecatalyst_list_source_repositories/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param nextToken A token returned from a call to this API to indicate the next batch of
#' results to return, if any.
#' @param maxResults The maximum number of results to show in a single call to this API. If
#' the number of results is larger than the number you specified, the
#' response will include a `NextToken` element, which you can use to obtain
#' additional results.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_list_source_repositories
codecatalyst_list_source_repositories <- function(spaceName, projectName, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSourceRepositories",
    http_method = "POST",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/sourceRepositories",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .codecatalyst$list_source_repositories_input(spaceName = spaceName, projectName = projectName, nextToken = nextToken, maxResults = maxResults)
  output <- .codecatalyst$list_source_repositories_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$list_source_repositories <- codecatalyst_list_source_repositories

#' Retrieves a list of branches in a specified source repository
#'
#' @description
#' Retrieves a list of branches in a specified source repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_list_source_repository_branches/](https://www.paws-r-sdk.com/docs/codecatalyst_list_source_repository_branches/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param sourceRepositoryName &#91;required&#93; The name of the source repository.
#' @param nextToken A token returned from a call to this API to indicate the next batch of
#' results to return, if any.
#' @param maxResults The maximum number of results to show in a single call to this API. If
#' the number of results is larger than the number you specified, the
#' response will include a `NextToken` element, which you can use to obtain
#' additional results.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_list_source_repository_branches
codecatalyst_list_source_repository_branches <- function(spaceName, projectName, sourceRepositoryName, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSourceRepositoryBranches",
    http_method = "POST",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/sourceRepositories/{sourceRepositoryName}/branches",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .codecatalyst$list_source_repository_branches_input(spaceName = spaceName, projectName = projectName, sourceRepositoryName = sourceRepositoryName, nextToken = nextToken, maxResults = maxResults)
  output <- .codecatalyst$list_source_repository_branches_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$list_source_repository_branches <- codecatalyst_list_source_repository_branches

#' Retrieves a list of spaces
#'
#' @description
#' Retrieves a list of spaces.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_list_spaces/](https://www.paws-r-sdk.com/docs/codecatalyst_list_spaces/) for full documentation.
#'
#' @param nextToken A token returned from a call to this API to indicate the next batch of
#' results to return, if any.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_list_spaces
codecatalyst_list_spaces <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListSpaces",
    http_method = "POST",
    http_path = "/v1/spaces",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "items")
  )
  input <- .codecatalyst$list_spaces_input(nextToken = nextToken)
  output <- .codecatalyst$list_spaces_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$list_spaces <- codecatalyst_list_spaces

#' Retrieves a list of workflow runs of a specified workflow
#'
#' @description
#' Retrieves a list of workflow runs of a specified workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_list_workflow_runs/](https://www.paws-r-sdk.com/docs/codecatalyst_list_workflow_runs/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param workflowId The ID of the workflow. To retrieve a list of workflow IDs, use
#' [`list_workflows`][codecatalyst_list_workflows].
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param nextToken A token returned from a call to this API to indicate the next batch of
#' results to return, if any.
#' @param maxResults The maximum number of results to show in a single call to this API. If
#' the number of results is larger than the number you specified, the
#' response will include a `NextToken` element, which you can use to obtain
#' additional results.
#' @param sortBy Information used to sort the items in the returned list.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_list_workflow_runs
codecatalyst_list_workflow_runs <- function(spaceName, workflowId = NULL, projectName, nextToken = NULL, maxResults = NULL, sortBy = NULL) {
  op <- new_operation(
    name = "ListWorkflowRuns",
    http_method = "POST",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/workflowRuns",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .codecatalyst$list_workflow_runs_input(spaceName = spaceName, workflowId = workflowId, projectName = projectName, nextToken = nextToken, maxResults = maxResults, sortBy = sortBy)
  output <- .codecatalyst$list_workflow_runs_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$list_workflow_runs <- codecatalyst_list_workflow_runs

#' Retrieves a list of workflows in a specified project
#'
#' @description
#' Retrieves a list of workflows in a specified project.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_list_workflows/](https://www.paws-r-sdk.com/docs/codecatalyst_list_workflows/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param nextToken A token returned from a call to this API to indicate the next batch of
#' results to return, if any.
#' @param maxResults The maximum number of results to show in a single call to this API. If
#' the number of results is larger than the number you specified, the
#' response will include a `NextToken` element, which you can use to obtain
#' additional results.
#' @param sortBy Information used to sort the items in the returned list.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_list_workflows
codecatalyst_list_workflows <- function(spaceName, projectName, nextToken = NULL, maxResults = NULL, sortBy = NULL) {
  op <- new_operation(
    name = "ListWorkflows",
    http_method = "POST",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/workflows",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .codecatalyst$list_workflows_input(spaceName = spaceName, projectName = projectName, nextToken = nextToken, maxResults = maxResults, sortBy = sortBy)
  output <- .codecatalyst$list_workflows_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$list_workflows <- codecatalyst_list_workflows

#' Starts a specified Dev Environment and puts it into an active state
#'
#' @description
#' Starts a specified Dev Environment and puts it into an active state.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_start_dev_environment/](https://www.paws-r-sdk.com/docs/codecatalyst_start_dev_environment/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param id &#91;required&#93; The system-generated unique ID of the Dev Environment.
#' @param ides Information about the integrated development environment (IDE)
#' configured for a Dev Environment.
#' @param instanceType The Amazon EC2 instace type to use for the Dev Environment.
#' @param inactivityTimeoutMinutes The amount of time the Dev Environment will run without any activity
#' detected before stopping, in minutes. Only whole integers are allowed.
#' Dev Environments consume compute minutes when running.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_start_dev_environment
codecatalyst_start_dev_environment <- function(spaceName, projectName, id, ides = NULL, instanceType = NULL, inactivityTimeoutMinutes = NULL) {
  op <- new_operation(
    name = "StartDevEnvironment",
    http_method = "PUT",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/devEnvironments/{id}/start",
    paginator = list()
  )
  input <- .codecatalyst$start_dev_environment_input(spaceName = spaceName, projectName = projectName, id = id, ides = ides, instanceType = instanceType, inactivityTimeoutMinutes = inactivityTimeoutMinutes)
  output <- .codecatalyst$start_dev_environment_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$start_dev_environment <- codecatalyst_start_dev_environment

#' Starts a session for a specified Dev Environment
#'
#' @description
#' Starts a session for a specified Dev Environment.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_start_dev_environment_session/](https://www.paws-r-sdk.com/docs/codecatalyst_start_dev_environment_session/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param id &#91;required&#93; The system-generated unique ID of the Dev Environment.
#' @param sessionConfiguration &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname codecatalyst_start_dev_environment_session
codecatalyst_start_dev_environment_session <- function(spaceName, projectName, id, sessionConfiguration) {
  op <- new_operation(
    name = "StartDevEnvironmentSession",
    http_method = "PUT",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/devEnvironments/{id}/session",
    paginator = list()
  )
  input <- .codecatalyst$start_dev_environment_session_input(spaceName = spaceName, projectName = projectName, id = id, sessionConfiguration = sessionConfiguration)
  output <- .codecatalyst$start_dev_environment_session_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$start_dev_environment_session <- codecatalyst_start_dev_environment_session

#' Begins a run of a specified workflow
#'
#' @description
#' Begins a run of a specified workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_start_workflow_run/](https://www.paws-r-sdk.com/docs/codecatalyst_start_workflow_run/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param workflowId &#91;required&#93; The system-generated unique ID of the workflow. To retrieve a list of
#' workflow IDs, use [`list_workflows`][codecatalyst_list_workflows].
#' @param clientToken A user-specified idempotency token. Idempotency ensures that an API
#' request completes only once. With an idempotent request, if the original
#' request completes successfully, the subsequent retries return the result
#' from the original successful request and have no additional effect.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_start_workflow_run
codecatalyst_start_workflow_run <- function(spaceName, projectName, workflowId, clientToken = NULL) {
  op <- new_operation(
    name = "StartWorkflowRun",
    http_method = "PUT",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/workflowRuns",
    paginator = list()
  )
  input <- .codecatalyst$start_workflow_run_input(spaceName = spaceName, projectName = projectName, workflowId = workflowId, clientToken = clientToken)
  output <- .codecatalyst$start_workflow_run_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$start_workflow_run <- codecatalyst_start_workflow_run

#' Pauses a specified Dev Environment and places it in a non-running state
#'
#' @description
#' Pauses a specified Dev Environment and places it in a non-running state. Stopped Dev Environments do not consume compute minutes.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_stop_dev_environment/](https://www.paws-r-sdk.com/docs/codecatalyst_stop_dev_environment/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param id &#91;required&#93; The system-generated unique ID of the Dev Environment.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_stop_dev_environment
codecatalyst_stop_dev_environment <- function(spaceName, projectName, id) {
  op <- new_operation(
    name = "StopDevEnvironment",
    http_method = "PUT",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/devEnvironments/{id}/stop",
    paginator = list()
  )
  input <- .codecatalyst$stop_dev_environment_input(spaceName = spaceName, projectName = projectName, id = id)
  output <- .codecatalyst$stop_dev_environment_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$stop_dev_environment <- codecatalyst_stop_dev_environment

#' Stops a session for a specified Dev Environment
#'
#' @description
#' Stops a session for a specified Dev Environment.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_stop_dev_environment_session/](https://www.paws-r-sdk.com/docs/codecatalyst_stop_dev_environment_session/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param id &#91;required&#93; The system-generated unique ID of the Dev Environment. To obtain this
#' ID, use [`list_dev_environments`][codecatalyst_list_dev_environments].
#' @param sessionId &#91;required&#93; The system-generated unique ID of the Dev Environment session. This ID
#' is returned by
#' [`start_dev_environment_session`][codecatalyst_start_dev_environment_session].
#'
#' @keywords internal
#'
#' @rdname codecatalyst_stop_dev_environment_session
codecatalyst_stop_dev_environment_session <- function(spaceName, projectName, id, sessionId) {
  op <- new_operation(
    name = "StopDevEnvironmentSession",
    http_method = "DELETE",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/devEnvironments/{id}/session/{sessionId}",
    paginator = list()
  )
  input <- .codecatalyst$stop_dev_environment_session_input(spaceName = spaceName, projectName = projectName, id = id, sessionId = sessionId)
  output <- .codecatalyst$stop_dev_environment_session_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$stop_dev_environment_session <- codecatalyst_stop_dev_environment_session

#' Changes one or more values for a Dev Environment
#'
#' @description
#' Changes one or more values for a Dev Environment. Updating certain values of the Dev Environment will cause a restart.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_update_dev_environment/](https://www.paws-r-sdk.com/docs/codecatalyst_update_dev_environment/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param projectName &#91;required&#93; The name of the project in the space.
#' @param id &#91;required&#93; The system-generated unique ID of the Dev Environment.
#' @param alias The user-specified alias for the Dev Environment. Changing this value
#' will not cause a restart.
#' @param ides Information about the integrated development environment (IDE)
#' configured for a Dev Environment.
#' @param instanceType The Amazon EC2 instace type to use for the Dev Environment.
#' 
#' Changing this value will cause a restart of the Dev Environment if it is
#' running.
#' @param inactivityTimeoutMinutes The amount of time the Dev Environment will run without any activity
#' detected before stopping, in minutes. Only whole integers are allowed.
#' Dev Environments consume compute minutes when running.
#' 
#' Changing this value will cause a restart of the Dev Environment if it is
#' running.
#' @param clientToken A user-specified idempotency token. Idempotency ensures that an API
#' request completes only once. With an idempotent request, if the original
#' request completes successfully, the subsequent retries return the result
#' from the original successful request and have no additional effect.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_update_dev_environment
codecatalyst_update_dev_environment <- function(spaceName, projectName, id, alias = NULL, ides = NULL, instanceType = NULL, inactivityTimeoutMinutes = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "UpdateDevEnvironment",
    http_method = "PATCH",
    http_path = "/v1/spaces/{spaceName}/projects/{projectName}/devEnvironments/{id}",
    paginator = list()
  )
  input <- .codecatalyst$update_dev_environment_input(spaceName = spaceName, projectName = projectName, id = id, alias = alias, ides = ides, instanceType = instanceType, inactivityTimeoutMinutes = inactivityTimeoutMinutes, clientToken = clientToken)
  output <- .codecatalyst$update_dev_environment_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$update_dev_environment <- codecatalyst_update_dev_environment

#' Changes one or more values for a project
#'
#' @description
#' Changes one or more values for a project.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_update_project/](https://www.paws-r-sdk.com/docs/codecatalyst_update_project/) for full documentation.
#'
#' @param spaceName &#91;required&#93; The name of the space.
#' @param name &#91;required&#93; The name of the project.
#' @param description The description of the project.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_update_project
codecatalyst_update_project <- function(spaceName, name, description = NULL) {
  op <- new_operation(
    name = "UpdateProject",
    http_method = "PATCH",
    http_path = "/v1/spaces/{spaceName}/projects/{name}",
    paginator = list()
  )
  input <- .codecatalyst$update_project_input(spaceName = spaceName, name = name, description = description)
  output <- .codecatalyst$update_project_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$update_project <- codecatalyst_update_project

#' Changes one or more values for a space
#'
#' @description
#' Changes one or more values for a space.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_update_space/](https://www.paws-r-sdk.com/docs/codecatalyst_update_space/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the space.
#' @param description The description of the space.
#'
#' @keywords internal
#'
#' @rdname codecatalyst_update_space
codecatalyst_update_space <- function(name, description = NULL) {
  op <- new_operation(
    name = "UpdateSpace",
    http_method = "PATCH",
    http_path = "/v1/spaces/{name}",
    paginator = list()
  )
  input <- .codecatalyst$update_space_input(name = name, description = description)
  output <- .codecatalyst$update_space_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$update_space <- codecatalyst_update_space

#' Verifies whether the calling user has a valid Amazon CodeCatalyst login
#' and session
#'
#' @description
#' Verifies whether the calling user has a valid Amazon CodeCatalyst login and session. If successful, this returns the ID of the user in Amazon CodeCatalyst.
#'
#' See [https://www.paws-r-sdk.com/docs/codecatalyst_verify_session/](https://www.paws-r-sdk.com/docs/codecatalyst_verify_session/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname codecatalyst_verify_session
codecatalyst_verify_session <- function() {
  op <- new_operation(
    name = "VerifySession",
    http_method = "GET",
    http_path = "/session",
    paginator = list()
  )
  input <- .codecatalyst$verify_session_input()
  output <- .codecatalyst$verify_session_output()
  config <- get_config()
  svc <- .codecatalyst$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecatalyst$operations$verify_session <- codecatalyst_verify_session
