# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS X-Ray
#'
#' @description
#' Amazon Web Services X-Ray provides APIs for managing debug traces and
#' retrieving service maps and other data created by processing those
#' traces.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- xray(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- xray()
#' svc$batch_get_traces(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=xray_batch_get_traces]{batch_get_traces} \tab Retrieves a list of traces specified by ID\cr
#'  \link[=xray_create_group]{create_group} \tab Creates a group resource with a name and a filter expression\cr
#'  \link[=xray_create_sampling_rule]{create_sampling_rule} \tab Creates a rule to control sampling behavior for instrumented applications\cr
#'  \link[=xray_delete_group]{delete_group} \tab Deletes a group resource\cr
#'  \link[=xray_delete_resource_policy]{delete_resource_policy} \tab Deletes a resource policy from the target Amazon Web Services account\cr
#'  \link[=xray_delete_sampling_rule]{delete_sampling_rule} \tab Deletes a sampling rule\cr
#'  \link[=xray_get_encryption_config]{get_encryption_config} \tab Retrieves the current encryption configuration for X-Ray data\cr
#'  \link[=xray_get_group]{get_group} \tab Retrieves group resource details\cr
#'  \link[=xray_get_groups]{get_groups} \tab Retrieves all active group details\cr
#'  \link[=xray_get_insight]{get_insight} \tab Retrieves the summary information of an insight\cr
#'  \link[=xray_get_insight_events]{get_insight_events} \tab X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event\cr
#'  \link[=xray_get_insight_impact_graph]{get_insight_impact_graph} \tab Retrieves a service graph structure filtered by the specified insight\cr
#'  \link[=xray_get_insight_summaries]{get_insight_summaries} \tab Retrieves the summaries of all insights in the specified group matching the provided filter values\cr
#'  \link[=xray_get_sampling_rules]{get_sampling_rules} \tab Retrieves all sampling rules\cr
#'  \link[=xray_get_sampling_statistic_summaries]{get_sampling_statistic_summaries} \tab Retrieves information about recent sampling results for all sampling rules\cr
#'  \link[=xray_get_sampling_targets]{get_sampling_targets} \tab Requests a sampling quota for rules that the service is using to sample requests\cr
#'  \link[=xray_get_service_graph]{get_service_graph} \tab Retrieves a document that describes services that process incoming requests, and downstream services that they call as a result\cr
#'  \link[=xray_get_time_series_service_statistics]{get_time_series_service_statistics} \tab Get an aggregation of service statistics defined by a specific time range\cr
#'  \link[=xray_get_trace_graph]{get_trace_graph} \tab Retrieves a service graph for one or more specific trace IDs\cr
#'  \link[=xray_get_trace_summaries]{get_trace_summaries} \tab Retrieves IDs and annotations for traces available for a specified time frame using an optional filter\cr
#'  \link[=xray_list_resource_policies]{list_resource_policies} \tab Returns the list of resource policies in the target Amazon Web Services account\cr
#'  \link[=xray_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule\cr
#'  \link[=xray_put_encryption_config]{put_encryption_config} \tab Updates the encryption configuration for X-Ray data\cr
#'  \link[=xray_put_resource_policy]{put_resource_policy} \tab Sets the resource policy to grant one or more Amazon Web Services services and accounts permissions to access X-Ray\cr
#'  \link[=xray_put_telemetry_records]{put_telemetry_records} \tab Used by the Amazon Web Services X-Ray daemon to upload telemetry\cr
#'  \link[=xray_put_trace_segments]{put_trace_segments} \tab Uploads segment documents to Amazon Web Services X-Ray\cr
#'  \link[=xray_tag_resource]{tag_resource} \tab Applies tags to an existing Amazon Web Services X-Ray group or sampling rule\cr
#'  \link[=xray_untag_resource]{untag_resource} \tab Removes tags from an Amazon Web Services X-Ray group or sampling rule\cr
#'  \link[=xray_update_group]{update_group} \tab Updates a group resource\cr
#'  \link[=xray_update_sampling_rule]{update_sampling_rule} \tab Modifies a sampling rule's configuration
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname xray
#' @export
xray <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .xray$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.xray <- list()

.xray$operations <- list()

.xray$metadata <- list(
  service_name = "xray",
  endpoints = list("*" = list(endpoint = "xray.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "xray.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "xray.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "xray.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "xray.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "xray.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "XRay",
  api_version = "2016-04-12",
  signing_name = "xray",
  json_version = "",
  target_prefix = ""
)

.xray$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.xray$metadata, handlers, config)
}
