% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drs_operations.R
\name{drs_update_replication_configuration_template}
\alias{drs_update_replication_configuration_template}
\title{Updates a ReplicationConfigurationTemplate by ID}
\usage{
drs_update_replication_configuration_template(
  arn = NULL,
  associateDefaultSecurityGroup = NULL,
  autoReplicateNewDisks = NULL,
  bandwidthThrottling = NULL,
  createPublicIP = NULL,
  dataPlaneRouting = NULL,
  defaultLargeStagingDiskType = NULL,
  ebsEncryption = NULL,
  ebsEncryptionKeyArn = NULL,
  pitPolicy = NULL,
  replicationConfigurationTemplateID,
  replicationServerInstanceType = NULL,
  replicationServersSecurityGroupsIDs = NULL,
  stagingAreaSubnetId = NULL,
  stagingAreaTags = NULL,
  useDedicatedReplicationServer = NULL
)
}
\arguments{
\item{arn}{The Replication Configuration Template ARN.}

\item{associateDefaultSecurityGroup}{Whether to associate the default Elastic Disaster Recovery Security
group with the Replication Configuration Template.}

\item{autoReplicateNewDisks}{Whether to allow the AWS replication agent to automatically replicate
newly added disks.}

\item{bandwidthThrottling}{Configure bandwidth throttling for the outbound data transfer rate of
the Source Server in Mbps.}

\item{createPublicIP}{Whether to create a Public IP for the Recovery Instance by default.}

\item{dataPlaneRouting}{The data plane routing mechanism that will be used for replication.}

\item{defaultLargeStagingDiskType}{The Staging Disk EBS volume type to be used during replication.}

\item{ebsEncryption}{The type of EBS encryption to be used during replication.}

\item{ebsEncryptionKeyArn}{The ARN of the EBS encryption key to be used during replication.}

\item{pitPolicy}{The Point in time (PIT) policy to manage snapshots taken during
replication.}

\item{replicationConfigurationTemplateID}{[required] The Replication Configuration Template ID.}

\item{replicationServerInstanceType}{The instance type to be used for the replication server.}

\item{replicationServersSecurityGroupsIDs}{The security group IDs that will be used by the replication server.}

\item{stagingAreaSubnetId}{The subnet to be used by the replication staging area.}

\item{stagingAreaTags}{A set of tags to be associated with all resources created in the
replication staging area: EC2 replication server, EBS volumes, EBS
snapshots, etc.}

\item{useDedicatedReplicationServer}{Whether to use a dedicated Replication Server in the replication staging
area.}
}
\description{
Updates a ReplicationConfigurationTemplate by ID.

See \url{https://www.paws-r-sdk.com/docs/drs_update_replication_configuration_template/} for full documentation.
}
\keyword{internal}
