% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_describe_sessions}
\alias{appstream_describe_sessions}
\title{Retrieves a list that describes the streaming sessions for a specified
stack and fleet}
\usage{
appstream_describe_sessions(StackName, FleetName, UserId, NextToken,
  Limit, AuthenticationType)
}
\arguments{
\item{StackName}{[required] The name of the stack. This value is case-sensitive.}

\item{FleetName}{[required] The name of the fleet. This value is case-sensitive.}

\item{UserId}{The user identifier (ID). If you specify a user ID, you must also
specify the authentication type.}

\item{NextToken}{The pagination token to use to retrieve the next page of results for
this operation. If this value is null, it retrieves the first page.}

\item{Limit}{The size of each page of results. The default value is 20 and the
maximum value is 50.}

\item{AuthenticationType}{The authentication method. Specify \code{API} for a user authenticated using
a streaming URL or \code{SAML} for a SAML federated user. The default is to
authenticate users using a streaming URL.}
}
\value{
A list with the following syntax:\preformatted{list(
  Sessions = list(
    list(
      Id = "string",
      UserId = "string",
      StackName = "string",
      FleetName = "string",
      State = "ACTIVE"|"PENDING"|"EXPIRED",
      ConnectionState = "CONNECTED"|"NOT_CONNECTED",
      StartTime = as.POSIXct(
        "2015-01-01"
      ),
      MaxExpirationTime = as.POSIXct(
        "2015-01-01"
      ),
      AuthenticationType = "API"|"SAML"|"USERPOOL",
      NetworkAccessConfiguration = list(
        EniPrivateIpAddress = "string",
        EniId = "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list that describes the streaming sessions for a specified
stack and fleet. If a UserId is provided for the stack and fleet, only
streaming sessions for that user are described. If an authentication
type is not provided, the default is to authenticate users using a
streaming URL.
}
\section{Request syntax}{
\preformatted{svc$describe_sessions(
  StackName = "string",
  FleetName = "string",
  UserId = "string",
  NextToken = "string",
  Limit = 123,
  AuthenticationType = "API"|"SAML"|"USERPOOL"
)
}
}

\keyword{internal}
