% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_register_workspace_directory}
\alias{workspaces_register_workspace_directory}
\title{Registers the specified directory}
\usage{
workspaces_register_workspace_directory(DirectoryId, SubnetIds,
  EnableWorkDocs, EnableSelfService, Tenancy, Tags)
}
\arguments{
\item{DirectoryId}{[required] The identifier of the directory. You cannot register a directory if it
does not have a status of Active. If the directory does not have a
status of Active, you will receive an InvalidResourceStateException
error. If you have already registered the maximum number of directories
that you can register with Amazon WorkSpaces, you will receive a
ResourceLimitExceededException error. Deregister directories that you
are not using for WorkSpaces, and try again.}

\item{SubnetIds}{The identifiers of the subnets for your virtual private cloud (VPC).
Make sure that the subnets are in supported Availability Zones. The
subnets must also be in separate Availability Zones. If these conditions
are not met, you will receive an OperationNotSupportedException error.}

\item{EnableWorkDocs}{[required] Indicates whether Amazon WorkDocs is enabled or disabled. If you have
enabled this parameter and WorkDocs is not available in the Region, you
will receive an OperationNotSupportedException error. Set
\code{EnableWorkDocs} to disabled, and try again.}

\item{EnableSelfService}{Indicates whether self-service capabilities are enabled or disabled.}

\item{Tenancy}{Indicates whether your WorkSpace directory is dedicated or shared. To
use Bring Your Own License (BYOL) images, this value must be set to
\code{DEDICATED} and your AWS account must be enabled for BYOL. If your
account has not been enabled for BYOL, you will receive an
InvalidParameterValuesException error. For more information about BYOL
images, see \href{https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html}{Bring Your Own Windows Desktop Images}.}

\item{Tags}{The tags associated with the directory.}
}
\value{
An empty list.
}
\description{
Registers the specified directory. This operation is asynchronous and
returns before the WorkSpace directory is registered. If this is the
first time you are registering a directory, you will need to create the
workspaces_DefaultRole role before you can register a directory. For
more information, see \href{https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role}{Creating the workspaces_DefaultRole Role}.
}
\section{Request syntax}{
\preformatted{svc$register_workspace_directory(
  DirectoryId = "string",
  SubnetIds = list(
    "string"
  ),
  EnableWorkDocs = TRUE|FALSE,
  EnableSelfService = TRUE|FALSE,
  Tenancy = "DEDICATED"|"SHARED",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
