% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_start_mailbox_export_job}
\alias{workmail_start_mailbox_export_job}
\title{Starts a mailbox export job to export MIME-format email messages and
calendar items from the specified mailbox to the specified Amazon Simple
Storage Service (Amazon S3) bucket}
\usage{
workmail_start_mailbox_export_job(
  ClientToken,
  OrganizationId,
  EntityId,
  Description = NULL,
  RoleArn,
  KmsKeyArn,
  S3BucketName,
  S3Prefix
)
}
\arguments{
\item{ClientToken}{[required] The idempotency token for the client request.}

\item{OrganizationId}{[required] The identifier associated with the organization.}

\item{EntityId}{[required] The identifier of the user or resource associated with the mailbox.}

\item{Description}{The mailbox export job description.}

\item{RoleArn}{[required] The ARN of the AWS Identity and Access Management (IAM) role that grants
write permission to the S3 bucket.}

\item{KmsKeyArn}{[required] The Amazon Resource Name (ARN) of the symmetric AWS Key Management
Service (AWS KMS) key that encrypts the exported mailbox content.}

\item{S3BucketName}{[required] The name of the S3 bucket.}

\item{S3Prefix}{[required] The S3 bucket prefix.}
}
\description{
Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see \href{https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html}{Exporting mailbox content} in the \emph{Amazon WorkMail Administrator Guide}.

See \url{https://paws-r.github.io/docs/workmail/start_mailbox_export_job.html} for full documentation.
}
\keyword{internal}
