% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_describe_users}
\alias{workdocs_describe_users}
\title{Describes the specified users}
\usage{
workdocs_describe_users(
  AuthenticationToken = NULL,
  OrganizationId = NULL,
  UserIds = NULL,
  Query = NULL,
  Include = NULL,
  Order = NULL,
  Sort = NULL,
  Marker = NULL,
  Limit = NULL,
  Fields = NULL
)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using Amazon Web
Services administrator credentials to access the API.}

\item{OrganizationId}{The ID of the organization.}

\item{UserIds}{The IDs of the users.}

\item{Query}{A query to filter users by user name. Remember the following about the
\code{Userids} and \code{Query} parameters:
\itemize{
\item If you don't use either parameter, the API returns a paginated list
of all users on the site.
\item If you use both parameters, the API ignores the \code{Query} parameter.
\item The \code{Userid} parameter only returns user names that match a
corresponding user ID.
\item The \code{Query} parameter runs a "prefix" search for users by the
\code{GivenName}, \code{SurName}, or \code{UserName} fields included in a
\code{\link[=workdocs_create_user]{create_user}} API call. For example,
querying on \code{Ma} returns Márcia Oliveira, María García, and Mateo
Jackson. If you use multiple characters, the API only returns data
that matches all characters. For example, querying on \verb{Ma J} only
returns Mateo Jackson.
}}

\item{Include}{The state of the users. Specify "ALL" to include inactive users.}

\item{Order}{The order for the results.}

\item{Sort}{The sorting criteria.}

\item{Marker}{The marker for the next set of results. (You received this marker from a
previous call.)}

\item{Limit}{The maximum number of items to return.}

\item{Fields}{A comma-separated list of values. Specify "STORAGE_METADATA" to include
the user storage quota and utilization information.}
}
\description{
Describes the specified users. You can describe all users or filter the results (for example, by status or organization).

See \url{https://www.paws-r-sdk.com/docs/workdocs_describe_users/} for full documentation.
}
\keyword{internal}
